/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.elemental;

import net.minecraft.world.item.Item;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.elemental.ElementalItem;

public class ElementalItemHelper {
    public static final String ERROR_MESSAGE = "Element Type must not be NONE";

    private ElementalItemHelper() {
    }

    public static Item getCrystalForElement(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> (ElementalItem)ECItems.AIR_CRYSTAL.get();
            case ElementType.EARTH -> (ElementalItem)ECItems.EARTH_CRYSTAL.get();
            case ElementType.FIRE -> (ElementalItem)ECItems.FIRE_CRYSTAL.get();
            case ElementType.WATER -> (ElementalItem)ECItems.WATER_CRYSTAL.get();
            default -> (Item)ECItems.INERT_CRYSTAL.get();
        };
    }

    public static Item getCrudeGemForElement(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> (ElementalItem)ECItems.CRUDE_AIR_GEM.get();
            case ElementType.EARTH -> (ElementalItem)ECItems.CRUDE_EARTH_GEM.get();
            case ElementType.FIRE -> (ElementalItem)ECItems.CRUDE_FIRE_GEM.get();
            case ElementType.WATER -> (ElementalItem)ECItems.CRUDE_WATER_GEM.get();
            default -> throw new IllegalArgumentException(ERROR_MESSAGE);
        };
    }

    public static Item getFineGemForElement(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> (ElementalItem)ECItems.FINE_AIR_GEM.get();
            case ElementType.EARTH -> (ElementalItem)ECItems.FINE_EARTH_GEM.get();
            case ElementType.FIRE -> (ElementalItem)ECItems.FINE_FIRE_GEM.get();
            case ElementType.WATER -> (ElementalItem)ECItems.FINE_WATER_GEM.get();
            default -> throw new IllegalArgumentException(ERROR_MESSAGE);
        };
    }

    public static Item getPristineGemForElement(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> (ElementalItem)ECItems.PRISTINE_AIR_GEM.get();
            case ElementType.EARTH -> (ElementalItem)ECItems.PRISTINE_EARTH_GEM.get();
            case ElementType.FIRE -> (ElementalItem)ECItems.PRISTINE_FIRE_GEM.get();
            case ElementType.WATER -> (ElementalItem)ECItems.PRISTINE_WATER_GEM.get();
            default -> throw new IllegalArgumentException(ERROR_MESSAGE);
        };
    }
}

