/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.chisel;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItemStackHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.pipe.IPipeInteractingItem;
import sirttas.elementalcraft.item.rune.RuneItem;

public class ChiselItem
extends TieredItem
implements IPipeInteractingItem {
    public static final String NAME_DRENCHED_IRON = "drenched_iron_chisel";
    public static final String NAME_SWIFT_ALLOY = "swift_alloy_chisel";
    public static final String NAME_FIREITE = "fireite_chisel";

    public ChiselItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Nonnull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        return this.doUse(BlockEntityHelper.getRuneHandlerAt((LevelReader)context.getLevel(), context.getClickedPos(), context.getClickedFace()), context).result();
    }

    @Override
    @Nonnull
    public ItemInteractionResult useOnPipe(@Nonnull ElementPipeBlockEntity pipe, @Nonnull UseOnContext context) {
        return this.doUse(BlockEntityHelper.getCapability(ElementalCraftCapabilities.RuneHandler.BLOCK, pipe, context.getClickedFace()), context);
    }

    @Nonnull
    private ItemInteractionResult doUse(IRuneHandler handler, UseOnContext context) {
        if (handler == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        List<Rune> runes = handler.getRunes();
        if (!runes.isEmpty() && player != null && player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                for (Rune rune : runes) {
                    if (stack.isEmpty()) continue;
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                    EntityHelper.dropAtFeet(level, (Entity)player, ((RuneItem)ECItems.RUNE.get()).getRuneStack(rune));
                    handler.removeRune(rune);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return ECItemStackHelper.canBeDamaged(stack);
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(@NotNull ItemStack stack) {
        return ECItemStackHelper.damageItem(stack);
    }
}

