/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.airmill.AirMillBlockItemModel;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.holder.ElementHolderItem;
import sirttas.elementalcraft.item.rune.RuneModel;
import sirttas.elementalcraft.pureore.display.PureOreDisplayManager;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class ItemModelHandler {
    private ItemModelHandler() {
    }

    @SubscribeEvent
    public static void replaceModels(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ItemModelHandler.replaceModels((Map<ModelResourceLocation, BakedModel>)modelRegistry, "rune", RuneModel::new);
        ItemModelHandler.replaceModels((Map<ModelResourceLocation, BakedModel>)modelRegistry, "air_mill_synthesizer", AirMillBlockItemModel::new);
        ItemModelHandler.replaceModels((Map<ModelResourceLocation, BakedModel>)modelRegistry, "air_mill_grindstone", AirMillBlockItemModel::new);
        ItemModelHandler.replaceModels((Map<ModelResourceLocation, BakedModel>)modelRegistry, "air_mill_wood_saw", AirMillBlockItemModel::new);
    }

    private static void replaceModels(Map<ModelResourceLocation, BakedModel> modelRegistry, String name, UnaryOperator<BakedModel> modelFactory) {
        ItemModelHandler.replaceModels(modelRegistry, name, (ModelResourceLocation k, BakedModel v) -> (BakedModel)modelFactory.apply((BakedModel)v));
    }

    private static void replaceModels(Map<ModelResourceLocation, BakedModel> modelRegistry, String name, BiFunction<ModelResourceLocation, BakedModel, BakedModel> modelFactory) {
        modelRegistry.computeIfPresent(ModelResourceLocation.inventory((ResourceLocation)ElementalCraftApi.createRL(name)), modelFactory);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((s, l) -> {
            int[] colors = PureOreDisplayManager.getInstance().getColors(s);
            return colors != null && l < colors.length ? colors[l] : -1;
        }, new ItemLike[]{(ItemLike)ECItems.PURE_ORE.get()});
        event.register((s, l) -> l == 0 ? -1 : FastColor.ARGB32.opaque((int)((Spell)SpellHelper.getSpell(s).value()).getColor()), new ItemLike[]{(ItemLike)ECItems.SCROLL.get()});
        event.register((s, l) -> l == 0 ? -1 : FastColor.ARGB32.opaque((int)((ElementHolderItem)s.getItem()).getElementType().getColor()), new ItemLike[]{(ItemLike)ECItems.FIRE_HOLDER.get(), (ItemLike)ECItems.WATER_HOLDER.get(), (ItemLike)ECItems.EARTH_HOLDER.get(), (ItemLike)ECItems.AIR_HOLDER.get()});
    }
}

