/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.airmill.AirMillBlockItem;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainerBlockItem;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlockItem;
import sirttas.elementalcraft.block.source.SourceBlock;
import sirttas.elementalcraft.block.source.trait.holder.ItemSourceTraitHolder;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.element.ElementAmounts;
import sirttas.elementalcraft.item.chisel.ChiselItem;
import sirttas.elementalcraft.item.chisel.ChiselTiers;
import sirttas.elementalcraft.item.elemental.DamageableCraftingElementalItem;
import sirttas.elementalcraft.item.elemental.ElementalItem;
import sirttas.elementalcraft.item.holder.ElementHolderItem;
import sirttas.elementalcraft.item.holder.PureElementHolderItem;
import sirttas.elementalcraft.item.jewel.JewelItem;
import sirttas.elementalcraft.item.pipe.CoverFrameItem;
import sirttas.elementalcraft.item.pipe.PipeUpgradeItem;
import sirttas.elementalcraft.item.pureore.PureOreItem;
import sirttas.elementalcraft.item.rune.RuneItem;
import sirttas.elementalcraft.item.source.SourceStabilizerItem;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassItem;
import sirttas.elementalcraft.item.source.receptacle.EmptyReceptacleItem;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleItem;
import sirttas.elementalcraft.item.spell.FocusItem;
import sirttas.elementalcraft.item.spell.ScrollItem;
import sirttas.elementalcraft.item.spell.SpellEffectItem;
import sirttas.elementalcraft.item.spell.StaffItem;
import sirttas.elementalcraft.item.spell.book.SpellBookItem;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.property.ECProperties;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.spell.SpellList;
import sirttas.elementalcraft.spell.Spells;

@EventBusSubscriber(modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class ECItems {
    private static final DeferredRegister<Item> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"elementalcraft");
    public static final DeferredHolder<Item, FocusItem> FOCUS = ECItems.register("focus", () -> new FocusItem(new Item.Properties().stacksTo(1).component(ECDataComponents.SPELL, Spells.NONE).component(ECDataComponents.SPELL_LIST, (Object)SpellList.EMPTY)));
    public static final DeferredHolder<Item, StaffItem> STAFF = ECItems.register("staff", () -> new StaffItem(new Item.Properties().durability(2252).fireResistant().component(ECDataComponents.SPELL, Spells.NONE).component(ECDataComponents.SPELL_LIST, (Object)SpellList.EMPTY).attributes(StaffItem.ATTRIBUTE_MODIFIERS)));
    public static final DeferredHolder<Item, ScrollItem> SCROLL = ECItems.register("scroll", () -> new ScrollItem(new Item.Properties().stacksTo(1).component(ECDataComponents.SPELL, Spells.NONE)));
    public static final DeferredHolder<Item, SpellBookItem> SPELL_BOOK = ECItems.register("spell_book", () -> new SpellBookItem(new Item.Properties().stacksTo(1).component(ECDataComponents.SPELL_LIST, (Object)SpellList.EMPTY)));
    public static final DeferredHolder<Item, EmptyReceptacleItem> EMPTY_RECEPTACLE = ECItems.register("empty_receptacle", () -> new EmptyReceptacleItem(new Item.Properties()));
    public static final DeferredHolder<Item, SourceStabilizerItem> SOURCE_STABILIZER = ECItems.register("source_stabilizer", SourceStabilizerItem::new);
    public static final DeferredHolder<Item, SourceAnalysisGlassItem> SOURCE_ANALYSIS_GLASS = ECItems.register("source_analysis_glass", SourceAnalysisGlassItem::new);
    public static final DeferredHolder<Item, ElementHolderItem> FIRE_HOLDER = ECItems.register("element_holder_fire", () -> new ElementHolderItem(ElementType.FIRE, ECProperties.Items.HOLDER));
    public static final DeferredHolder<Item, ElementHolderItem> WATER_HOLDER = ECItems.register("element_holder_water", () -> new ElementHolderItem(ElementType.WATER, ECProperties.Items.HOLDER));
    public static final DeferredHolder<Item, ElementHolderItem> EARTH_HOLDER = ECItems.register("element_holder_earth", () -> new ElementHolderItem(ElementType.EARTH, ECProperties.Items.HOLDER));
    public static final DeferredHolder<Item, ElementHolderItem> AIR_HOLDER = ECItems.register("element_holder_air", () -> new ElementHolderItem(ElementType.AIR, ECProperties.Items.HOLDER));
    public static final DeferredHolder<Item, Item> PURE_HOLDER_CORE = ECItems.register("pure_element_holder_core", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, PureElementHolderItem> PURE_HOLDER = ECItems.register("pure_element_holder", () -> new PureElementHolderItem(new Item.Properties().stacksTo(1).component(ECDataComponents.ELEMENT_AMOUNTS, (Object)ElementAmounts.EMPTY)));
    public static final DeferredHolder<Item, PureOreItem> PURE_ORE = ECItems.register("pure_ore", () -> new PureOreItem(new Item.Properties()));
    public static final DeferredHolder<Item, RuneItem> RUNE = ECItems.register("rune", () -> new RuneItem(ECProperties.Items.ITEM_UNSTACKABLE));
    public static final DeferredHolder<Item, ChiselItem> DRENCHED_IRON_CHISEL = ECItems.register("drenched_iron_chisel", () -> new ChiselItem(ChiselTiers.DRENCHED_IRON, new Item.Properties()));
    public static final DeferredHolder<Item, ChiselItem> SWIFT_ALLOY_CHISEL = ECItems.register("swift_alloy_chisel", () -> new ChiselItem(ChiselTiers.SWIFT_ALLOY, new Item.Properties()));
    public static final DeferredHolder<Item, ChiselItem> FIREITE_CHISEL = ECItems.register("fireite_chisel", () -> new ChiselItem(ChiselTiers.FIREITE, new Item.Properties().fireResistant()));
    public static final DeferredHolder<Item, DamageableCraftingElementalItem> ELEMENTAL_FIREFUEL = ECItems.register("elemental_firefuel", () -> new DamageableCraftingElementalItem(ElementType.FIRE, new Item.Properties().stacksTo(1).durability(500)));
    public static final DeferredHolder<Item, CoverFrameItem> COVER_FRAME = ECItems.register("cover_frame", () -> new CoverFrameItem(new Item.Properties()));
    public static final DeferredHolder<Item, PipeUpgradeItem> ELEMENT_PUMP = ECItems.registerPipeUpgrade(PipeUpgradeTypes.ELEMENT_PUMP);
    public static final DeferredHolder<Item, PipeUpgradeItem> PIPE_PRIORITY_RINGS = ECItems.registerPipeUpgrade(PipeUpgradeTypes.PIPE_PRIORITY_RINGS);
    public static final DeferredHolder<Item, PipeUpgradeItem> ELEMENT_VALVE = ECItems.registerPipeUpgrade(PipeUpgradeTypes.ELEMENT_VALVE);
    public static final DeferredHolder<Item, PipeUpgradeItem> ELEMENT_BEAM = ECItems.registerPipeUpgrade(PipeUpgradeTypes.ELEMENT_BEAM);
    public static final DeferredHolder<Item, Item> INERT_CRYSTAL = ECItems.register("inert_crystal", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> CONTAINED_CRYSTAL = ECItems.register("contained_crystal", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> STRONGLY_CONTAINED_CRYSTAL = ECItems.register("strongly_contained_crystal", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> PURE_CRYSTAL = ECItems.register("purecrystal", () -> new Item(new Item.Properties().component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true)));
    public static final DeferredHolder<Item, Item> DRENCHED_IRON_INGOT = ECItems.register("drenched_iron_ingot", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> DRENCHED_IRON_NUGGET = ECItems.register("drenched_iron_nugget", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SWIFT_ALLOY_INGOT = ECItems.register("swift_alloy_ingot", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SWIFT_ALLOY_NUGGET = ECItems.register("swift_alloy_nugget", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> HARDENED_HANDLE = ECItems.register("hardened_handle", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> DRENCHED_SAW_BLADE = ECItems.register("drenched_saw_blade", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SHRINE_BASE = ECItems.register("shrinebase", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> FIREITE_INGOT = ECItems.register("fireite_ingot", () -> new Item(new Item.Properties().fireResistant()));
    public static final DeferredHolder<Item, Item> FIREITE_NUGGET = ECItems.register("fireite_nugget", () -> new Item(new Item.Properties().fireResistant()));
    public static final DeferredHolder<Item, Item> AIR_SILK = ECItems.register("air_silk", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SHRINE_UPGRADE_CORE = ECItems.register("shrine_upgrade_core", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> ADVANCED_SHRINE_UPGRADE_CORE = ECItems.register("advanced_shrine_upgrade_core", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SCROLL_PAPER = ECItems.register("scroll_paper", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SPRINGALINE_SHARD = ECItems.register("springaline_shard", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> SOLAR_PRISM = ECItems.register("solar_prism", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> FIRE_CRYSTAL = ECItems.register("firecrystal", () -> new ElementalItem(ElementType.FIRE, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> WATER_CRYSTAL = ECItems.register("watercrystal", () -> new ElementalItem(ElementType.WATER, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> EARTH_CRYSTAL = ECItems.register("earthcrystal", () -> new ElementalItem(ElementType.EARTH, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> AIR_CRYSTAL = ECItems.register("aircrystal", () -> new ElementalItem(ElementType.AIR, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> CRUDE_FIRE_GEM = ECItems.register("crude_fire_gem", () -> new ElementalItem(ElementType.FIRE, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> CRUDE_WATER_GEM = ECItems.register("crude_water_gem", () -> new ElementalItem(ElementType.WATER, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> CRUDE_EARTH_GEM = ECItems.register("crude_earth_gem", () -> new ElementalItem(ElementType.EARTH, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> CRUDE_AIR_GEM = ECItems.register("crude_air_gem", () -> new ElementalItem(ElementType.AIR, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> FINE_FIRE_GEM = ECItems.register("fine_fire_gem", () -> new ElementalItem(ElementType.FIRE, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> FINE_WATER_GEM = ECItems.register("fine_water_gem", () -> new ElementalItem(ElementType.WATER, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> FINE_EARTH_GEM = ECItems.register("fine_earth_gem", () -> new ElementalItem(ElementType.EARTH, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> FINE_AIR_GEM = ECItems.register("fine_air_gem", () -> new ElementalItem(ElementType.AIR, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> PRISTINE_FIRE_GEM = ECItems.register("pristine_fire_gem", () -> new ElementalItem(ElementType.FIRE, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> PRISTINE_WATER_GEM = ECItems.register("pristine_water_gem", () -> new ElementalItem(ElementType.WATER, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> PRISTINE_EARTH_GEM = ECItems.register("pristine_earth_gem", () -> new ElementalItem(ElementType.EARTH, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> PRISTINE_AIR_GEM = ECItems.register("pristine_air_gem", () -> new ElementalItem(ElementType.AIR, new Item.Properties()));
    public static final DeferredHolder<Item, Item> PRISTINE_SHARD = ECItems.register("pristine_shard", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, DamageableCraftingElementalItem> FIRE_LENS = ECItems.register("fire_lens", () -> new DamageableCraftingElementalItem(ElementType.FIRE, new Item.Properties().stacksTo(1).durability(1500)));
    public static final DeferredHolder<Item, DamageableCraftingElementalItem> AIR_MILL = ECItems.register("air_mill", () -> new DamageableCraftingElementalItem(ElementType.AIR, new Item.Properties().stacksTo(1).durability(3000)));
    public static final DeferredHolder<Item, Item> MINOR_RUNE_SLATE = ECItems.register("minor_rune_slate", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> RUNE_SLATE = ECItems.register("rune_slate", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> MAJOR_RUNE_SLATE = ECItems.register("major_rune_slate", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, Item> UNSET_JEWEL = ECItems.register("unset_jewel", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, JewelItem> SALMON_JEWEL = ECItems.registerJewel(Jewels.SALMON);
    public static final DeferredHolder<Item, JewelItem> PHOENIX_JEWEL = ECItems.registerJewel(Jewels.PHOENIX);
    public static final DeferredHolder<Item, JewelItem> BASILISK_JEWEL = ECItems.registerJewel(Jewels.BASILISK);
    public static final DeferredHolder<Item, JewelItem> BEAR_JEWEL = ECItems.registerJewel(Jewels.BEAR);
    public static final DeferredHolder<Item, JewelItem> TIGER_JEWEL = ECItems.registerJewel(Jewels.TIGER);
    public static final DeferredHolder<Item, JewelItem> LEOPARD_JEWEL = ECItems.registerJewel(Jewels.LEOPARD);
    public static final DeferredHolder<Item, JewelItem> DOLPHIN_JEWEL = ECItems.registerJewel(Jewels.DOLPHIN);
    public static final DeferredHolder<Item, JewelItem> KIRIN_JEWEL = ECItems.registerJewel(Jewels.KIRIN);
    public static final DeferredHolder<Item, JewelItem> VIPER_JEWEL = ECItems.registerJewel(Jewels.VIPER);
    public static final DeferredHolder<Item, JewelItem> TORTOISE_JEWEL = ECItems.registerJewel(Jewels.TORTOISE);
    public static final DeferredHolder<Item, JewelItem> ARCTIC_HARE_JEWEL = ECItems.registerJewel(Jewels.ARCTIC_HARE);
    public static final DeferredHolder<Item, JewelItem> MOLE_JEWEL = ECItems.registerJewel(Jewels.MOLE);
    public static final DeferredHolder<Item, JewelItem> HAWK_JEWEL = ECItems.registerJewel(Jewels.HAWK);
    public static final DeferredHolder<Item, JewelItem> DEMIGOD_JEWEL = ECItems.registerJewel(Jewels.DEMIGOD);
    public static final DeferredHolder<Item, JewelItem> STRIDER_JEWEL = ECItems.registerJewel(Jewels.STRIDER);
    public static final DeferredHolder<Item, JewelItem> WATER_STRIDER_JEWEL = ECItems.registerJewel(Jewels.WATER_STRIDER);
    public static final DeferredHolder<Item, JewelItem> PIGLIN_JEWEL = ECItems.registerJewel(Jewels.PIGLIN);
    public static final DeferredHolder<Item, ElementalItem> FIRE_SOURCE_SEED = ECItems.register("fire_source_seed", () -> new ElementalItem(ElementType.FIRE, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> WATER_SOURCE_SEED = ECItems.register("water_source_seed", () -> new ElementalItem(ElementType.WATER, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> EARTH_SOURCE_SEED = ECItems.register("earth_source_seed", () -> new ElementalItem(ElementType.EARTH, new Item.Properties()));
    public static final DeferredHolder<Item, ElementalItem> AIR_SOURCE_SEED = ECItems.register("air_source_seed", () -> new ElementalItem(ElementType.AIR, new Item.Properties()));
    public static final DeferredHolder<Item, SpellEffectItem> REPAIR_HAMMER = ECItems.register("repair_hammer", () -> new SpellEffectItem(new Item.Properties()));

    private ECItems() {
    }

    @SubscribeEvent
    public static void registerBlockItems(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.ITEM)) {
            return;
        }
        Registry registry = event.getRegistry();
        event.register(Registries.ITEM, (T r) -> {
            RegistryHelper.register(r, new BlockItem((Block)ECBlocks.FIREITE_BLOCK.get(), new Item.Properties().fireResistant()), ECBlocks.FIREITE_BLOCK);
            RegistryHelper.register(r, new AirMillBlockItem((Block)ECBlocks.AIR_MILL_GRINDSTONE.get(), new Item.Properties()), ECBlocks.AIR_MILL_GRINDSTONE);
            RegistryHelper.register(r, new AirMillBlockItem((Block)ECBlocks.AIR_MILL_WOOD_SAW.get(), new Item.Properties()), ECBlocks.AIR_MILL_WOOD_SAW);
            RegistryHelper.register(r, new AirMillBlockItem((Block)ECBlocks.AIR_MILL_SYNTHESIZER.get(), new Item.Properties()), ECBlocks.AIR_MILL_SYNTHESIZER);
            RegistryHelper.register(r, new TranslocationShrineUpgradeBlockItem((Block)ECBlocks.TRANSLOCATION_SHRINE_UPGRADE.get(), new Item.Properties()), ECBlocks.TRANSLOCATION_SHRINE_UPGRADE);
            for (Map.Entry entry : BuiltInRegistries.BLOCK.entrySet()) {
                Block selector0$temp;
                Block block = (Block)entry.getValue();
                ResourceLocation registryName = ((ResourceKey)entry.getKey()).location();
                if (!ElementalCraft.owns(registryName) || registry.containsKey(registryName)) continue;
                Objects.requireNonNull(block);
                int index$1 = 0;
                RegistryHelper.register(r, registryName, switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractElementContainerBlock.class, SourceBlock.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        ElementType v1;
                        AbstractElementContainerBlock containerBlock = (AbstractElementContainerBlock)selector0$temp;
                        Item.Properties v0 = new Item.Properties();
                        if (block instanceof IElementTypeProvider) {
                            IElementTypeProvider provider = (IElementTypeProvider)block;
                            v1 = provider.getElementType();
                        } else {
                            v1 = ElementType.NONE;
                        }
                        yield new ElementContainerBlockItem(containerBlock, v0.component(ECDataComponents.ELEMENT_TYPE, (Object)v1).component(ECDataComponents.ELEMENT_AMOUNT, (Object)0));
                    }
                    case 1 -> {
                        SourceBlock sourceBlock = (SourceBlock)selector0$temp;
                        yield new ReceptacleItem(sourceBlock, new Item.Properties().stacksTo(1).component(ECDataComponents.SOURCE_TRAITS_HOLDER, (Object)ItemSourceTraitHolder.EMPTY).component(ECDataComponents.ELEMENT_AMOUNT, (Object)5000000));
                    }
                    default -> new BlockItem(block, new Item.Properties());
                });
            }
        });
    }

    private static <T extends PipeUpgrade> DeferredHolder<Item, PipeUpgradeItem> registerPipeUpgrade(DeferredHolder<PipeUpgradeType<?>, PipeUpgradeType<T>> pipeUpgrade) {
        return ECItems.register(pipeUpgrade.getId().getPath(), () -> new PipeUpgradeItem(() -> ((DeferredHolder)pipeUpgrade).get(), new Item.Properties()));
    }

    private static DeferredHolder<Item, JewelItem> registerJewel(DeferredHolder<Jewel, ? extends Jewel> jewel) {
        return ECItems.register(jewel.getId().getPath(), () -> new JewelItem(() -> ((DeferredHolder)jewel).get(), new Item.Properties().stacksTo(1)));
    }

    private static <T extends Item> DeferredHolder<Item, T> register(String name, Supplier<T> item) {
        return DEFERRED_REGISTER.register(name, item);
    }

    public static void register(IEventBus bus) {
        ECBlocks.registerAliases(DEFERRED_REGISTER);
        Jewels.registerAliases(DEFERRED_REGISTER);
        DEFERRED_REGISTER.addAlias(ElementalCraftApi.createRL("chisel"), ElementalCraftApi.createRL("swift_alloy_chisel"));
        DEFERRED_REGISTER.addAlias(ElementalCraftApi.createRL("natural_fire_source_seed"), ElementalCraftApi.createRL("fire_source_seed"));
        DEFERRED_REGISTER.addAlias(ElementalCraftApi.createRL("natural_water_source_seed"), ElementalCraftApi.createRL("water_source_seed"));
        DEFERRED_REGISTER.addAlias(ElementalCraftApi.createRL("natural_earth_source_seed"), ElementalCraftApi.createRL("earth_source_seed"));
        DEFERRED_REGISTER.addAlias(ElementalCraftApi.createRL("natural_air_source_seed"), ElementalCraftApi.createRL("air_source_seed"));
        DEFERRED_REGISTER.register(bus);
    }
}

