/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ECItemStackHelper {
    private ECItemStackHelper() {
    }

    public static boolean canBeDamaged(@NotNull ItemStack stack) {
        return !stack.isEmpty() && stack.getMaxDamage() - stack.getDamageValue() > 1;
    }

    @NotNull
    public static ItemStack damageItem(@NotNull ItemStack stack) {
        return ECItemStackHelper.damageItem(stack, 1);
    }

    @NotNull
    public static ItemStack damageItem(@NotNull ItemStack stack, int damage) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = stack.copy();
        int damageValue = result.getDamageValue() + damage;
        result.setDamageValue(damageValue);
        if (damageValue >= result.getMaxDamage()) {
            result.shrink(1);
        }
        if (result.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return result;
    }
}

