/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.interaction.ECInteractions;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.holder.ElementHolderItem;
import sirttas.elementalcraft.item.holder.PureElementHolderItem;
import sirttas.elementalcraft.item.rune.RuneItem;
import sirttas.elementalcraft.pureore.PureOreManager;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

public class ECCreativeModeTabs {
    private static final DeferredRegister<CreativeModeTab> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.key(), (String)"elementalcraft");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> ELEMENTAL_CRAFT_CREATIVE_TAB = DEFERRED_REGISTER.register("elemental_craft", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.elementalcraft")).icon(() -> new ItemStack(ECItems.FOCUS)).displayItems((p, o) -> {
        o.accept((ItemLike)ECBlocks.RUDIMENTARY_EXTRACTOR.get());
        o.accept((ItemLike)ECBlocks.EXTRACTOR.get());
        o.accept((ItemLike)ECBlocks.IMPROVED_EXTRACTOR.get());
        o.accept((ItemLike)ECBlocks.INFUSER.get());
        o.accept((ItemLike)ECBlocks.CRACKING_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.COMBUSTION_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.DRAINING_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.VIBRATION_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.SOLAR_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.CULINARY_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.SCULK_CRACKING_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.AIR_MILL_SYNTHESIZER.get());
        o.accept((ItemLike)ECBlocks.DIFFUSER.get());
        o.accept((ItemLike)ECBlocks.BINDER.get());
        o.accept((ItemLike)ECBlocks.BINDER_IMPROVED.get());
        o.accept((ItemLike)ECBlocks.CRYSTALLIZER.get());
        o.accept((ItemLike)ECBlocks.INSCRIBER.get());
        o.accept((ItemLike)ECBlocks.WATER_MILL_GRINDSTONE.get());
        o.accept((ItemLike)ECBlocks.AIR_MILL_GRINDSTONE.get());
        o.accept((ItemLike)ECBlocks.WATER_MILL_WOOD_SAW.get());
        o.accept((ItemLike)ECBlocks.AIR_MILL_WOOD_SAW.get());
        o.accept((ItemLike)ECBlocks.ENCHANTMENT_LIQUEFIER.get());
        o.accept((ItemLike)ECBlocks.FIRE_PEDESTAL.get());
        o.accept((ItemLike)ECBlocks.WATER_PEDESTAL.get());
        o.accept((ItemLike)ECBlocks.EARTH_PEDESTAL.get());
        o.accept((ItemLike)ECBlocks.AIR_PEDESTAL.get());
        o.accept((ItemLike)ECBlocks.PURE_INFUSER.get());
        o.accept((ItemLike)ECBlocks.FIRE_FURNACE.get());
        o.accept((ItemLike)ECBlocks.FIRE_BLAST_FURNACE.get());
        o.accept((ItemLike)ECBlocks.PURIFIER.get());
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.SMALL_CONTAINER);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.CONTAINER);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.FIRE_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.WATER_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.EARTH_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.AIR_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.CREATIVE_CONTAINER);
        o.accept((ItemLike)ECBlocks.PIPE_RUDIMENTARY.get());
        o.accept((ItemLike)ECBlocks.PIPE.get());
        o.accept((ItemLike)ECBlocks.PIPE_IMPROVED.get());
        o.accept((ItemLike)ECBlocks.PIPE_CREATIVE.get());
        o.accept((ItemLike)ECItems.COVER_FRAME.get());
        o.accept((ItemLike)ECItems.ELEMENT_PUMP.get());
        o.accept((ItemLike)ECItems.PIPE_PRIORITY_RINGS.get());
        o.accept((ItemLike)ECItems.ELEMENT_VALVE.get());
        o.accept((ItemLike)ECItems.ELEMENT_BEAM.get());
        o.accept((ItemLike)ECBlocks.RETRIEVER.get());
        o.accept((ItemLike)ECBlocks.SORTER.get());
        o.accept((ItemLike)ECBlocks.SPELL_DESK.get());
        o.accept((ItemLike)ECBlocks.FIRE_PYLON.get());
        o.accept((ItemLike)ECBlocks.VACUUM_SHRINE.get());
        o.accept((ItemLike)ECBlocks.GROWTH_SHRINE.get());
        o.accept((ItemLike)ECBlocks.HARVEST_SHRINE.get());
        o.accept((ItemLike)ECBlocks.LUMBER_SHRINE.get());
        o.accept((ItemLike)ECBlocks.MELTING_SHRINE.get());
        o.accept((ItemLike)ECBlocks.ORE_SHRINE.get());
        o.accept((ItemLike)ECBlocks.OVERLOAD_SHRINE.get());
        o.accept((ItemLike)ECBlocks.SWEET_SHRINE.get());
        o.accept((ItemLike)ECBlocks.ENDER_LOCK_SHRINE.get());
        o.accept((ItemLike)ECBlocks.BREEDING_SHRINE.get());
        o.accept((ItemLike)ECBlocks.GROVE_SHRINE.get());
        o.accept((ItemLike)ECBlocks.SPRING_SHRINE.get());
        o.accept((ItemLike)ECBlocks.BUDDING_SHRINE.get());
        o.accept((ItemLike)ECBlocks.SPAWNING_SHRINE.get());
        o.accept((ItemLike)ECBlocks.ACCELERATION_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.OVERCLOCKED_ACCELERATION_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.RANGE_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.CAPACITY_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.EFFICIENCY_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.STRENGTH_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.OVERWHELMING_STRENGTH_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.OPTIMIZATION_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.FORTUNE_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.GREATER_FORTUNE_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.SILK_TOUCH_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.PLANTING_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.BONELESS_GROWTH_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.PICKUP_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.VORTEX_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.NECTAR_SHRINE_UPGRADE.get());
        if (ECInteractions.isBotaniaActive()) {
            o.accept((ItemLike)ECBlocks.MYSTICAL_GROVE_SHRINE_UPGRADE.get());
        }
        o.accept((ItemLike)ECBlocks.STEM_POLLINATION_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.PROTECTION_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.FILLING_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.SPRINGALINE_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.CRYSTAL_HARVEST_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.CRYSTAL_GROWTH_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.TRANSLOCATION_SHRINE_UPGRADE.get());
        o.accept((ItemLike)ECBlocks.SOURCE_BREEDER.get());
        o.accept((ItemLike)ECBlocks.SOURCE_BREEDER_PEDESTAL.get());
        o.accept((ItemLike)ECItems.FIRE_SOURCE_SEED.get());
        o.accept((ItemLike)ECItems.WATER_SOURCE_SEED.get());
        o.accept((ItemLike)ECItems.EARTH_SOURCE_SEED.get());
        o.accept((ItemLike)ECItems.AIR_SOURCE_SEED.get());
        o.accept((ItemLike)ECBlocks.TRANSLOCATION_ANCHOR.get());
        o.accept((ItemLike)ECBlocks.CRYSTAL_ORE.get());
        o.accept((ItemLike)ECBlocks.DEEPSLATE_CRYSTAL_ORE.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_SLAB.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_STAIRS.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_WALL.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_FENCE.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_BRICK.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_BRICK_SLAB.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_BRICK_STAIRS.get());
        o.accept((ItemLike)ECBlocks.WHITE_ROCK_BRICK_WALL.get());
        o.accept((ItemLike)ECBlocks.MOSSY_WHITE_ROCK.get());
        o.accept((ItemLike)ECBlocks.MOSSY_WHITE_ROCK_SLAB.get());
        o.accept((ItemLike)ECBlocks.MOSSY_WHITE_ROCK_STAIRS.get());
        o.accept((ItemLike)ECBlocks.MOSSY_WHITE_ROCK_WALL.get());
        o.accept((ItemLike)ECBlocks.BURNT_WHITE_ROCK.get());
        o.accept((ItemLike)ECBlocks.BURNT_WHITE_ROCK_SLAB.get());
        o.accept((ItemLike)ECBlocks.BURNT_WHITE_ROCK_STAIRS.get());
        o.accept((ItemLike)ECBlocks.BURNT_WHITE_ROCK_WALL.get());
        o.accept((ItemLike)ECBlocks.BURNT_GLASS.get());
        o.accept((ItemLike)ECBlocks.BURNT_GLASS_PANE.get());
        o.accept((ItemLike)ECBlocks.PURE_ROCK.get());
        o.accept((ItemLike)ECBlocks.PURE_ROCK_SLAB.get());
        o.accept((ItemLike)ECBlocks.PURE_ROCK_STAIRS.get());
        o.accept((ItemLike)ECBlocks.PURE_ROCK_WALL.get());
        o.accept((ItemLike)ECItems.FOCUS.get());
        o.accept((ItemLike)ECItems.STAFF.get());
        ECCreativeModeTabs.generateSpells(o);
        o.accept((ItemLike)ECItems.SPELL_BOOK.get());
        o.accept((ItemLike)ECItems.SOURCE_ANALYSIS_GLASS.get());
        o.accept((ItemLike)ECItems.EMPTY_RECEPTACLE.get());
        o.accept((ItemLike)ECBlocks.FIRE_SOURCE.get());
        o.accept((ItemLike)ECBlocks.WATER_SOURCE.get());
        o.accept((ItemLike)ECBlocks.EARTH_SOURCE.get());
        o.accept((ItemLike)ECBlocks.AIR_SOURCE.get());
        o.accept((ItemLike)ECItems.SOURCE_STABILIZER.get());
        ECCreativeModeTabs.generateElementHolder(o, ECItems.FIRE_HOLDER);
        ECCreativeModeTabs.generateElementHolder(o, ECItems.WATER_HOLDER);
        ECCreativeModeTabs.generateElementHolder(o, ECItems.EARTH_HOLDER);
        ECCreativeModeTabs.generateElementHolder(o, ECItems.AIR_HOLDER);
        o.accept((ItemLike)ECItems.PURE_HOLDER_CORE.get());
        ECCreativeModeTabs.generatePureElementHolder(o);
        o.accept((ItemLike)ECItems.DRENCHED_IRON_CHISEL.get());
        o.accept((ItemLike)ECItems.SWIFT_ALLOY_CHISEL.get());
        o.accept((ItemLike)ECItems.FIREITE_CHISEL.get());
        o.accept((ItemLike)ECItems.ELEMENTAL_FIREFUEL.get());
        ECCreativeModeTabs.generatePureOres(o);
        o.accept((ItemLike)ECItems.INERT_CRYSTAL.get());
        o.accept((ItemLike)ECBlocks.INERT_CRYSTAL_BLOCK.get());
        o.accept((ItemLike)ECItems.CONTAINED_CRYSTAL.get());
        o.accept((ItemLike)ECItems.STRONGLY_CONTAINED_CRYSTAL.get());
        o.accept((ItemLike)ECItems.FIRE_CRYSTAL.get());
        o.accept((ItemLike)ECBlocks.FIRE_CRYSTAL_BLOCK.get());
        o.accept((ItemLike)ECItems.WATER_CRYSTAL.get());
        o.accept((ItemLike)ECBlocks.WATER_CRYSTAL_BLOCK.get());
        o.accept((ItemLike)ECItems.EARTH_CRYSTAL.get());
        o.accept((ItemLike)ECBlocks.EARTH_CRYSTAL_BLOCK.get());
        o.accept((ItemLike)ECItems.AIR_CRYSTAL.get());
        o.accept((ItemLike)ECBlocks.AIR_CRYSTAL_BLOCK.get());
        o.accept((ItemLike)ECItems.PURE_CRYSTAL.get());
        o.accept((ItemLike)ECItems.CRUDE_FIRE_GEM.get());
        o.accept((ItemLike)ECItems.CRUDE_WATER_GEM.get());
        o.accept((ItemLike)ECItems.CRUDE_EARTH_GEM.get());
        o.accept((ItemLike)ECItems.CRUDE_AIR_GEM.get());
        o.accept((ItemLike)ECItems.FINE_FIRE_GEM.get());
        o.accept((ItemLike)ECItems.FINE_WATER_GEM.get());
        o.accept((ItemLike)ECItems.FINE_EARTH_GEM.get());
        o.accept((ItemLike)ECItems.FINE_AIR_GEM.get());
        o.accept((ItemLike)ECItems.PRISTINE_FIRE_GEM.get());
        o.accept((ItemLike)ECItems.PRISTINE_WATER_GEM.get());
        o.accept((ItemLike)ECItems.PRISTINE_EARTH_GEM.get());
        o.accept((ItemLike)ECItems.PRISTINE_AIR_GEM.get());
        o.accept((ItemLike)ECItems.PRISTINE_SHARD.get());
        o.accept((ItemLike)ECItems.DRENCHED_IRON_NUGGET.get());
        o.accept((ItemLike)ECItems.DRENCHED_IRON_INGOT.get());
        o.accept((ItemLike)ECBlocks.DRENCHED_IRON_BLOCK.get());
        o.accept((ItemLike)ECItems.SWIFT_ALLOY_NUGGET.get());
        o.accept((ItemLike)ECItems.SWIFT_ALLOY_INGOT.get());
        o.accept((ItemLike)ECBlocks.SWIFT_ALLOY_BLOCK.get());
        o.accept((ItemLike)ECItems.FIREITE_NUGGET.get());
        o.accept((ItemLike)ECItems.FIREITE_INGOT.get());
        o.accept((ItemLike)ECBlocks.FIREITE_BLOCK.get());
        o.accept((ItemLike)ECItems.SPRINGALINE_SHARD.get());
        o.accept((ItemLike)ECBlocks.SPRINGALINE_BLOCK.get());
        o.accept((ItemLike)ECBlocks.SMALL_SPRINGALINE_BUD.get());
        o.accept((ItemLike)ECBlocks.MEDIUM_SPRINGALINE_BUD.get());
        o.accept((ItemLike)ECBlocks.LARGE_SPRINGALINE_BUD.get());
        o.accept((ItemLike)ECBlocks.SPRINGALINE_CLUSTER.get());
        o.accept((ItemLike)ECBlocks.SPRINGALINE_GLASS.get());
        o.accept((ItemLike)ECBlocks.SPRINGALINE_GLASS_PANE.get());
        o.accept((ItemLike)ECBlocks.SPRINGALINE_LANTERN.get());
        o.accept((ItemLike)ECItems.SOLAR_PRISM.get());
        o.accept((ItemLike)ECItems.FIRE_LENS.get());
        o.accept((ItemLike)ECItems.AIR_MILL.get());
        o.accept((ItemLike)ECItems.AIR_SILK.get());
        o.accept((ItemLike)ECItems.HARDENED_HANDLE.get());
        o.accept((ItemLike)ECItems.DRENCHED_SAW_BLADE.get());
        o.accept((ItemLike)ECItems.SCROLL_PAPER.get());
        o.accept((ItemLike)ECItems.SHRINE_BASE.get());
        o.accept((ItemLike)ECItems.SHRINE_UPGRADE_CORE.get());
        o.accept((ItemLike)ECItems.ADVANCED_SHRINE_UPGRADE_CORE.get());
        o.accept((ItemLike)ECItems.MINOR_RUNE_SLATE.get());
        o.accept((ItemLike)ECItems.RUNE_SLATE.get());
        o.accept((ItemLike)ECItems.MAJOR_RUNE_SLATE.get());
        ECCreativeModeTabs.generateRunes(o);
        o.accept((ItemLike)ECItems.UNSET_JEWEL.get());
        o.accept((ItemLike)ECItems.SALMON_JEWEL.get());
        o.accept((ItemLike)ECItems.PHOENIX_JEWEL.get());
        o.accept((ItemLike)ECItems.BASILISK_JEWEL.get());
        o.accept((ItemLike)ECItems.BEAR_JEWEL.get());
        o.accept((ItemLike)ECItems.TIGER_JEWEL.get());
        o.accept((ItemLike)ECItems.LEOPARD_JEWEL.get());
        o.accept((ItemLike)ECItems.DOLPHIN_JEWEL.get());
        o.accept((ItemLike)ECItems.KIRIN_JEWEL.get());
        o.accept((ItemLike)ECItems.VIPER_JEWEL.get());
        o.accept((ItemLike)ECItems.TORTOISE_JEWEL.get());
        o.accept((ItemLike)ECItems.ARCTIC_HARE_JEWEL.get());
        o.accept((ItemLike)ECItems.MOLE_JEWEL.get());
        o.accept((ItemLike)ECItems.HAWK_JEWEL.get());
        o.accept((ItemLike)ECItems.DEMIGOD_JEWEL.get());
        o.accept((ItemLike)ECItems.STRIDER_JEWEL.get());
        o.accept((ItemLike)ECItems.WATER_STRIDER_JEWEL.get());
        o.accept((ItemLike)ECItems.PIGLIN_JEWEL.get());
    }).build());

    private static void generateElementContainer(@Nonnull CreativeModeTab.Output output, @Nonnull Supplier<? extends AbstractElementContainerBlock> supplier) {
        List<ElementType> list;
        AbstractElementContainerBlock block = supplier.get();
        Item item = block.asItem();
        output.accept(new ItemStack((ItemLike)item));
        if (block instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)((Object)block);
            list = List.of(provider.getElementType());
        } else {
            list = ElementType.ALL_VALID;
        }
        for (ElementType type : list) {
            ItemStack stack = new ItemStack((ItemLike)item);
            stack.set(ECDataComponents.ELEMENT_TYPE, (Object)type);
            stack.set(ECDataComponents.ELEMENT_AMOUNT, (Object)block.getDefaultCapacity());
            output.accept(stack);
        }
    }

    private static void generateElementHolder(@Nonnull CreativeModeTab.Output output, @Nonnull Supplier<? extends ElementHolderItem> supplier) {
        ElementHolderItem item = supplier.get();
        ItemStack full = new ItemStack((ItemLike)item);
        ISingleElementStorage storage = item.getElementStorage(full);
        storage.insertElement(item.getElementCapacity(), false);
        output.accept(new ItemStack((ItemLike)item));
        output.accept(full);
    }

    private static void generatePureElementHolder(@Nonnull CreativeModeTab.Output output) {
        PureElementHolderItem item = (PureElementHolderItem)((Object)ECItems.PURE_HOLDER.get());
        ItemStack full = new ItemStack((ItemLike)item);
        IElementStorage storage = item.getElementStorage(full);
        storage.fill();
        output.accept(new ItemStack((ItemLike)item));
        output.accept(full);
    }

    private static void generateSpells(@Nonnull CreativeModeTab.Output output) {
        Spells.REGISTRY.holders().filter(SpellHelper::isVisible).map(s -> {
            ItemStack stack = new ItemStack(ECItems.SCROLL);
            SpellHelper.setSpell(stack, (Holder<Spell>)s);
            return stack;
        }).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }

    private static void generatePureOres(@Nonnull CreativeModeTab.Output output) {
        PureOreManager.getInstance().getOres().forEach(id -> output.accept(PureOreManager.getInstance().createPureOre((ResourceLocation)id)));
    }

    private static void generateRunes(@Nonnull CreativeModeTab.Output output) {
        RuneItem item = (RuneItem)ECItems.RUNE.get();
        ElementalCraftApi.RUNE_MANAGER.getData().forEach((l, r) -> output.accept(item.getRuneStack((Rune)r)));
    }

    private ECCreativeModeTabs() {
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

