/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.mekanism.injector;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.registration.impl.RecipeTypeRegistryObject;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import sirttas.elementalcraft.api.pureore.factory.AbstractPureOreRecipeFactory;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractMekanismPureOreRecipeFactory<I extends RecipeInput, T extends MekanismRecipe<I>>
extends AbstractPureOreRecipeFactory<I, T> {
    protected AbstractMekanismPureOreRecipeFactory(@Nonnull RecipeManager recipeManager, @Nonnull RecipeTypeRegistryObject<I, T, ?> recipeType) {
        super(recipeManager, recipeType.getRecipeType());
    }

    @Nonnull
    protected static ItemStackIngredient getInput(Ingredient ingredient, ItemStackIngredient old) {
        List representations = old.getRepresentations();
        if (!representations.isEmpty()) {
            return AbstractMekanismPureOreRecipeFactory.getInput(ingredient, (int)old.getNeededAmount((ItemStack)representations.getFirst()));
        }
        return AbstractMekanismPureOreRecipeFactory.getInput(ingredient);
    }

    @Nonnull
    protected static ItemStackIngredient getInput(Ingredient ingredient) {
        return IngredientCreatorAccess.item().from(ingredient, AbstractMekanismPureOreRecipeFactory.getInputMultiplier(1L));
    }

    @Nonnull
    protected static ItemStackIngredient getInput(Ingredient ingredient, int size) {
        return IngredientCreatorAccess.item().from(ingredient, AbstractMekanismPureOreRecipeFactory.getInputMultiplier(size));
    }

    protected static ChemicalStackIngredient tweakOutput(ChemicalStackIngredient chemicalInput) {
        return IngredientCreatorAccess.chemicalStack().from(chemicalInput.ingredient(), (long)AbstractMekanismPureOreRecipeFactory.getOutputMultiplier(chemicalInput.amount()));
    }

    protected static ItemStack tweakOutput(ItemStack stack) {
        ItemStack copy = stack.copy();
        copy.setCount(AbstractMekanismPureOreRecipeFactory.getOutputMultiplier(stack.getCount()));
        return copy;
    }

    protected static ChemicalStack tweakOutput(ChemicalStack stack) {
        ChemicalStack copy = stack.copy();
        copy.setAmount((long)AbstractMekanismPureOreRecipeFactory.getOutputMultiplier(stack.getAmount()));
        return copy;
    }

    protected static int getInputMultiplier(long count) {
        return (int)Math.max(2L, count * (long)((Integer)ECConfig.SERVER.mekanismPureOreInputMultiplier.get()).intValue());
    }

    protected static int getOutputMultiplier(long count) {
        return (int)Math.max(2L, count * (long)((Integer)ECConfig.SERVER.mekanismPureOreOutputMultiplier.get()).intValue());
    }

    @Override
    public boolean filter(RecipeHolder<T> recipe, ItemStack stack) {
        return stack.is(ECTags.Items.PURE_ORES_SOURCES_ORES);
    }
}

