/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.mekanism;

import java.util.function.BiFunction;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.basic.BasicCrushingRecipe;
import mekanism.api.recipes.basic.BasicEnrichingRecipe;
import mekanism.api.recipes.basic.BasicInjectingRecipe;
import mekanism.api.recipes.basic.BasicPurifyingRecipe;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registration.impl.RecipeTypeRegistryObject;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.RegisterEvent;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.factory.IPureOreRecipeFactory;
import sirttas.elementalcraft.api.pureore.factory.IPureOreRecipeFactoryType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.mekanism.injector.ChemicalDissolutionPureOreRecipeFactory;
import sirttas.elementalcraft.interaction.mekanism.injector.ItemStackGasToItemStackPureOreRecipeFactory;
import sirttas.elementalcraft.interaction.mekanism.injector.ItemStackToItemStackPureOreRecipeFactory;
import sirttas.elementalcraft.interaction.mekanism.recipe.MekanismCrusherRecipeWrapper;
import sirttas.elementalcraft.pureore.factory.PureOreRecipeFactoryTypes;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;

public class MekanismInteraction {
    private MekanismInteraction() {
    }

    public static void registerPureOreRecipeInjectors(RegisterEvent.RegisterHelper<IPureOreRecipeFactoryType<?, ? extends Recipe<?>>> registry) {
        MekanismInteraction.register(registry, MekanismRecipeType.DISSOLUTION, ChemicalDissolutionPureOreRecipeFactory::new);
        MekanismInteraction.register(registry, MekanismRecipeType.INJECTING, (m, t) -> new ItemStackGasToItemStackPureOreRecipeFactory<ItemStackChemicalToItemStackRecipe>((RecipeManager)m, (RecipeTypeRegistryObject<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, InputRecipeCache.ItemChemical<ItemStackChemicalToItemStackRecipe>>)t, BasicInjectingRecipe::new));
        MekanismInteraction.register(registry, MekanismRecipeType.PURIFYING, (m, t) -> new ItemStackGasToItemStackPureOreRecipeFactory<ItemStackChemicalToItemStackRecipe>((RecipeManager)m, (RecipeTypeRegistryObject<SingleItemChemicalRecipeInput, ItemStackChemicalToItemStackRecipe, InputRecipeCache.ItemChemical<ItemStackChemicalToItemStackRecipe>>)t, BasicPurifyingRecipe::new));
        MekanismInteraction.register(registry, MekanismRecipeType.ENRICHING, (m, t) -> new ItemStackToItemStackPureOreRecipeFactory<ItemStackToItemStackRecipe>((RecipeManager)m, (RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>>)t, BasicEnrichingRecipe::new));
        MekanismInteraction.register(registry, MekanismRecipeType.CRUSHING, (m, t) -> new ItemStackToItemStackPureOreRecipeFactory<ItemStackToItemStackRecipe>((RecipeManager)m, (RecipeTypeRegistryObject<SingleRecipeInput, ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>>)t, BasicCrushingRecipe::new));
    }

    private static <I extends RecipeInput, T extends MekanismRecipe<I>, C extends IInputRecipeCache> void register(RegisterEvent.RegisterHelper<IPureOreRecipeFactoryType<?, ? extends Recipe<?>>> registry, RecipeTypeRegistryObject<I, T, C> type, BiFunction<RecipeManager, RecipeTypeRegistryObject<I, T, C>, IPureOreRecipeFactory<I, T>> factory) {
        PureOreRecipeFactoryTypes.register(registry, type.getRegistryName(), (RecipeManager m) -> (IPureOreRecipeFactory)factory.apply(m, type));
    }

    public static void addMillsToCrushing(IRecipeCatalystRegistration registry) {
        try {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.WATER_MILL_GRINDSTONE.get()), new RecipeType[]{MekanismJEI.holderRecipeType((IRecipeViewerRecipeType)RecipeViewerRecipeType.CRUSHING)});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_MILL_GRINDSTONE.get()), new RecipeType[]{MekanismJEI.holderRecipeType((IRecipeViewerRecipeType)RecipeViewerRecipeType.CRUSHING)});
        }
        catch (Exception e) {
            ElementalCraftApi.LOGGER.warn("Failed to add mills to mekanism crushing catalysts.", (Throwable)e);
        }
    }

    public static IGrindingRecipe lookupCrusherRecipe(Level level, SimpleIOInstrumentRecipeInput recipeInput) {
        ItemStack stack = recipeInput.getItem(0);
        ItemStackToItemStackRecipe crusherRecipe = (ItemStackToItemStackRecipe)MekanismRecipeType.CRUSHING.findFirst(level, recipe -> recipe.test(stack));
        MekanismCrusherRecipeWrapper wrapper = crusherRecipe != null ? new MekanismCrusherRecipeWrapper(crusherRecipe) : null;
        return wrapper != null && wrapper.matches(recipeInput, level) ? wrapper : null;
    }
}

