/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.source;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.event.TickHandler;
import sirttas.elementalcraft.interaction.jei.ingredient.source.IngredientSource;

public class SourceIngredientRenderer
implements IIngredientRenderer<IngredientSource> {
    private static final ResourceLocation OUTER = ElementalCraftApi.createRL("textures/effect/source_outer.png");
    private static final ResourceLocation MIDDLE = ElementalCraftApi.createRL("textures/effect/source_middle.png");

    public void render(@Nonnull GuiGraphics guiGraphics, @Nonnull IngredientSource source) {
        ElementType elementType = source.getElementType();
        PoseStack poseStack = guiGraphics.pose();
        long angle = -(TickHandler.getTicksInGame() % 360L);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)elementType.getRed(), (float)elementType.getGreen(), (float)elementType.getBlue(), (float)1.0f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(16.0f, 16.0f, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)angle));
        poseStack.translate(-16.0f, -16.0f, 0.0f);
        guiGraphics.blit(OUTER, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        poseStack.translate(16.0f, 16.0f, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)angle * 5.0f));
        poseStack.translate(-16.0, -16.0, -0.01);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.blit(MIDDLE, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    public List<Component> getTooltip(@NotNull IngredientSource ingredientSource, @NotNull TooltipFlag tooltipFlag) {
        return List.of();
    }

    public void getTooltip(ITooltipBuilder tooltip, IngredientSource ingredient, @NotNull TooltipFlag tooltipFlag) {
        tooltip.add((FormattedText)ingredient.getDisplayName());
    }
}

