/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.source;

import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.source.IngredientSource;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;

public class SourceIngredientHelper
implements IIngredientHelper<IngredientSource> {
    @Nonnull
    public String getDisplayName(IngredientSource ingredient) {
        return I18n.get((String)ingredient.getTranslationKey(), (Object[])new Object[0]);
    }

    @Nonnull
    public String getUniqueId(@Nonnull IngredientSource ingredient, @Nonnull UidContext context) {
        return this.getName(ingredient);
    }

    @Nonnull
    private String getName(IngredientSource ingredient) {
        return ingredient.getElementType().getSerializedName() + "_source";
    }

    @Nonnull
    public Object getUid(@NotNull IngredientSource ingredient, @Nonnull UidContext context) {
        return this.getName(ingredient);
    }

    @Nonnull
    public ResourceLocation getResourceLocation(@Nonnull IngredientSource ingredient) {
        return ElementalCraftApi.createRL(this.getName(ingredient));
    }

    @Nonnull
    public IngredientSource copyIngredient(IngredientSource ingredient) {
        return ingredient.copy();
    }

    public boolean isValidIngredient(IngredientSource ingredient) {
        return ingredient.getElementType() != ElementType.NONE;
    }

    @Nonnull
    public String getErrorInfo(IngredientSource ingredient) {
        return ingredient != null && ingredient.getElementType() == ElementType.NONE ? "Element shouldn't be none" : "";
    }

    @Nonnull
    public IIngredientType<IngredientSource> getIngredientType() {
        return ECIngredientTypes.SOURCE;
    }

    @Nonnull
    public ItemStack getCheatItemStack(IngredientSource ingredient) {
        return ReceptacleHelper.create(ingredient.getElementType());
    }
}

