/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.source;

import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;

public record IngredientSource(ElementType elementType) implements IElementTypeProvider
{
    public static final Codec<IngredientSource> CODEC = ElementType.CODEC.xmap(IngredientSource::new, IngredientSource::getElementType);

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getTranslationKey());
    }

    @Nonnull
    public String getTranslationKey() {
        return "block.elementalcraft." + this.elementType.getSerializedName() + "_source";
    }

    public IngredientSource copy() {
        return new IngredientSource(this.elementType);
    }

    public static List<IngredientSource> all() {
        return ElementType.ALL_VALID.stream().map(IngredientSource::new).toList();
    }
}

