/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.element;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;

public record IngredientElementType(ElementType elementType, int amount) implements IElementTypeProvider
{
    public static final Codec<IngredientElementType> CODEC = RecordCodecBuilder.create(builder -> builder.group(ElementType.forGetter(IngredientElementType::elementType), (App)Codec.INT.fieldOf("element_amount").forGetter(IngredientElementType::amount)).apply((Applicative)builder, IngredientElementType::new));

    public IngredientElementType(ElementType elementType, int amount) {
        this.elementType = elementType;
        this.amount = Mth.clamp((int)amount, (int)-1, (int)4);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    public Component getDisplayName() {
        return this.elementType.getDisplayName();
    }

    public IngredientElementType copy() {
        return new IngredientElementType(this.elementType, this.amount);
    }

    public static int getGaugeValue(int amount) {
        return (int)Math.log10(amount) - 1;
    }

    @Nonnull
    public static IngredientElementType fromIngredient(@Nonnull Ingredient ingredient) {
        return new IngredientElementType(IngredientElementType.getElementType(ingredient), 1);
    }

    private static ElementType getElementType(Ingredient recipe) {
        ItemStack[] stacks = recipe.getItems();
        if (stacks.length > 0) {
            return ElementType.getElementType(stacks[0]);
        }
        return ElementType.NONE;
    }

    public static List<IngredientElementType> all() {
        return IngredientElementType.all(-1);
    }

    public static List<IngredientElementType> all(int amount) {
        return ElementType.ALL_VALID.stream().map(type -> new IngredientElementType((ElementType)type, amount)).toList();
    }
}

