/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.element;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;

public class ElementIngredientRenderer
implements IIngredientRenderer<IngredientElementType> {
    public void render(@Nonnull GuiGraphics guiGraphics, @Nonnull IngredientElementType ingredient) {
        int amount = ingredient.amount();
        GuiHelper.renderElementGauge(guiGraphics, Minecraft.getInstance().font, 0, 0, amount == -1 ? 4 : amount, 4, ingredient.getElementType(), false);
    }

    public List<Component> getTooltip(@NotNull IngredientElementType ingredientElementType, @NotNull TooltipFlag tooltipFlag) {
        return List.of();
    }

    public void getTooltip(ITooltipBuilder tooltip, IngredientElementType ingredient, @Nonnull TooltipFlag tooltipFlag) {
        int amount = ingredient.amount();
        tooltip.add((FormattedText)ingredient.getDisplayName());
        if (amount != -1) {
            tooltip.add((FormattedText)Component.translatable((String)("tooltip.elementalcraft.element_amount." + amount)).withStyle(ChatFormatting.GREEN));
        }
    }
}

