/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.element;

import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;

public class ElementIngredientHelper
implements IIngredientHelper<IngredientElementType> {
    @Nonnull
    public String getDisplayName(IngredientElementType ingredient) {
        return I18n.get((String)ingredient.getElementType().getDescriptionId(), (Object[])new Object[0]);
    }

    @Nonnull
    public String getUniqueId(IngredientElementType ingredient, @Nonnull UidContext context) {
        return ingredient.getElementType().getSerializedName();
    }

    @Nonnull
    public Object getUid(@Nonnull IngredientElementType ingredient, @Nonnull UidContext context) {
        return ingredient.getElementType();
    }

    @Nonnull
    public ResourceLocation getResourceLocation(IngredientElementType ingredient) {
        return ElementalCraftApi.createRL(ingredient.getElementType().getSerializedName());
    }

    @Nonnull
    public IngredientElementType copyIngredient(IngredientElementType ingredient) {
        return ingredient.copy();
    }

    public boolean isValidIngredient(IngredientElementType ingredient) {
        return ingredient.getElementType() != ElementType.NONE;
    }

    @Nonnull
    public String getErrorInfo(IngredientElementType ingredient) {
        return ingredient != null && ingredient.getElementType() == ElementType.NONE ? "Element shouldn't be none" : "";
    }

    @Nonnull
    public IIngredientType<IngredientElementType> getIngredientType() {
        return ECIngredientTypes.ELEMENT;
    }
}

