/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument.io.mill;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.AbstractIOInstrumentRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;

public abstract class AbstractMillRecipeCategory<I extends RecipeInput, T extends IInstrumentRecipe<I>>
extends AbstractIOInstrumentRecipeCategory<I, T> {
    private final List<ItemStack> instruments;

    protected AbstractMillRecipeCategory(IGuiHelper guiHelper, String translationKey, ItemLike ... instruments) {
        super(guiHelper, translationKey, instruments[0]);
        this.instruments = Arrays.stream(instruments).map(ItemStack::new).toList();
    }

    @Override
    protected List<ItemStack> getContainers() {
        return List.of(this.container, new ItemStack((ItemLike)ECBlocks.SMALL_CONTAINER.get()));
    }

    @Override
    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull T recipe, @Nonnull IFocusGroup focuses) {
        NonNullList ingredients = recipe.getIngredients();
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addIngredients((Ingredient)ingredients.getFirst());
        List<ItemStack> containers = this.getContainers();
        List<IngredientElementType> types = this.getElementTypeIngredients(recipe);
        IRecipeSlotBuilder instrumentsSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 30, 24).addItemStacks(this.instruments);
        IRecipeSlotBuilder containersSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 30, 40).addItemStacks(containers);
        IRecipeSlotBuilder typesSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 30, 58).addIngredients(ECIngredientTypes.ELEMENT, types);
        if (this.instruments.size() == containers.size() && this.instruments.size() == types.size()) {
            builder.createFocusLink(new IIngredientAcceptor[]{instrumentsSlot, containersSlot, typesSlot});
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 0).addItemStacks(this.getOutputs(recipe));
    }
}

