/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument.io;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.jei.category.instrument.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;

public abstract class AbstractIOInstrumentRecipeCategory<I extends RecipeInput, T extends IInstrumentRecipe<I>>
extends AbstractInstrumentRecipeCategory<I, T> {
    protected final ItemStack container = new ItemStack((ItemLike)ECBlocks.CONTAINER.get());
    protected final ItemStack instrument;

    protected AbstractIOInstrumentRecipeCategory(IGuiHelper guiHelper, String translationKey, ItemLike item) {
        this(guiHelper, translationKey, new ItemStack(item));
    }

    protected AbstractIOInstrumentRecipeCategory(IGuiHelper guiHelper, String translationKey, ItemStack instrument) {
        super(translationKey, AbstractIOInstrumentRecipeCategory.createDrawableStack(guiHelper, instrument), 75, 75);
        this.instrument = instrument;
        this.addOverlay((IDrawable)guiHelper.createDrawable(ElementalCraftApi.createRL("textures/gui/overlay/io.png"), 0, 0, 65, 16), 8, 20);
    }

    protected List<ItemStack> getContainers() {
        return List.of(this.container);
    }

    @Nonnull
    protected List<ItemStack> getOutputs(@Nonnull T recipe) {
        return List.of(RecipeUtil.getResultItem(recipe));
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull T recipe, @Nonnull IFocusGroup focuses) {
        NonNullList ingredients = recipe.getIngredients();
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addIngredients((Ingredient)ingredients.getFirst());
        builder.addSlot(RecipeIngredientRole.CATALYST, 30, 24).addItemStack(this.instrument);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 30, 40).addItemStacks(this.getContainers());
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 58).addIngredients(ECIngredientTypes.ELEMENT, this.getElementTypeIngredients(recipe));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 0).addItemStacks(this.getOutputs(recipe));
    }
}

