/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.instrument.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.recipe.instrument.IInstrumentRecipe;
import sirttas.elementalcraft.recipe.instrument.enchantment.liquefaction.EnchantmentLiquefactionRecipe;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;

public class EnchantmentLiquefactionRecipeCategory
extends AbstractInstrumentRecipeCategory<SimpleIOInstrumentRecipeInput, RecipeWrapper> {
    private static final ItemStack ENCHANTMENT_LIQUEFIER = new ItemStack((ItemLike)ECBlocks.ENCHANTMENT_LIQUEFIER.get());
    private final List<ItemStack> containers = List.of(new ItemStack((ItemLike)ECBlocks.CONTAINER.get()), new ItemStack((ItemLike)ECBlocks.WATER_RESERVOIR.get()));

    public EnchantmentLiquefactionRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.enchantment_liquefaction", EnchantmentLiquefactionRecipeCategory.createDrawableStack(guiHelper, ENCHANTMENT_LIQUEFIER), 86, 100);
        this.addOverlay((IDrawable)guiHelper.createDrawable(ElementalCraftApi.createRL("textures/gui/overlay/enchantment_liquefaction.png"), 0, 0, 46, 13), 20, 20);
    }

    @Nonnull
    public RecipeType<RecipeWrapper> getRecipeType() {
        return ECJEIRecipeTypes.ENCHANTMENT_LIQUEFACTION;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull RecipeWrapper recipe, @Nonnull IFocusGroup focuses) {
        List<ItemStack> stacks = recipe.stacks;
        List<ItemStack> enchantmentStacks = recipe.enchantmentStacks;
        builder.createFocusLink(new IIngredientAcceptor[]{builder.addSlot(RecipeIngredientRole.INPUT, 17, 4).addItemStacks(enchantmentStacks), builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 54, 4).addItemStacks(stacks)});
        builder.createFocusLink(new IIngredientAcceptor[]{builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 17, 33).addItemStacks(Lists.reverse(stacks)), builder.addSlot(RecipeIngredientRole.OUTPUT, 54, 33).addItemStacks(Lists.reverse(enchantmentStacks))});
        builder.addSlot(RecipeIngredientRole.CATALYST, 35, 42).addItemStack(ENCHANTMENT_LIQUEFIER);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 35, 58).addItemStacks(this.containers);
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 76).addIngredients(ECIngredientTypes.ELEMENT, this.getElementTypeIngredients(recipe));
    }

    public static class RecipeWrapper
    implements IInstrumentRecipe<SimpleIOInstrumentRecipeInput> {
        private final EnchantmentLiquefactionRecipe recipe;
        private final List<ItemStack> stacks;
        private final List<ItemStack> enchantmentStacks;

        public RecipeWrapper(EnchantmentLiquefactionRecipe recipe, int level, List<ItemStack> stacks) {
            this.recipe = recipe;
            this.stacks = (List)Util.make(() -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(stacks.size() + 1);
                list.add(new ItemStack((ItemLike)Items.BOOK));
                list.addAll(stacks);
                return list;
            });
            this.enchantmentStacks = (List)Util.make(() -> {
                ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(stacks.size() + 1);
                ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                mutable.set(recipe.getEnchantment(), level);
                ItemEnchantments enchantments = mutable.toImmutable();
                EnchantmentHelper.setEnchantments((ItemStack)book, (ItemEnchantments)enchantments);
                list.add(book);
                stacks.stream().map(s -> {
                    ItemStack copy = s.copy();
                    EnchantmentHelper.setEnchantments((ItemStack)copy, (ItemEnchantments)enchantments);
                    return copy;
                }).forEach(list::add);
                return list;
            });
        }

        public boolean matches(@NotNull SimpleIOInstrumentRecipeInput input, @NotNull Level level) {
            return this.recipe.matches(input, level);
        }

        @Override
        public List<ElementType> getValidElementTypes() {
            return this.recipe.getValidElementTypes();
        }

        @Override
        public int getElementAmount() {
            return this.recipe.getElementAmount();
        }

        @NotNull
        public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
            return this.recipe.getResultItem(provider);
        }

        @NotNull
        public RecipeSerializer<?> getSerializer() {
            return this.recipe.getSerializer();
        }

        @NotNull
        public net.minecraft.world.item.crafting.RecipeType<?> getType() {
            return this.recipe.getType();
        }
    }
}

