/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument;

import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.instrument.AbstractInstrumentRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.recipe.input.MultipleItemsSingleElementRecipeInput;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;

public class BindingRecipeCategory
extends AbstractInstrumentRecipeCategory<MultipleItemsSingleElementRecipeInput, AbstractBindingRecipe> {
    private final ItemStack container = new ItemStack((ItemLike)ECBlocks.CONTAINER.get());
    private static final ItemStack BINDER = new ItemStack((ItemLike)ECBlocks.BINDER.get());
    private static final int RADIUS = 42;

    public BindingRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.binding", BindingRecipeCategory.createDrawableStack(guiHelper, BINDER), 132, 100);
        this.addOverlay((IDrawable)guiHelper.createDrawable(ElementalCraftApi.createRL("textures/gui/overlay/binding.png"), 0, 0, 124, 83), 10, 10);
    }

    @Nonnull
    public RecipeType<AbstractBindingRecipe> getRecipeType() {
        return ECJEIRecipeTypes.BINDING;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull AbstractBindingRecipe recipe, @Nonnull IFocusGroup focuses) {
        int i = 0;
        NonNullList ingredients = recipe.getIngredients();
        for (Ingredient ingredient : ingredients) {
            double a = Math.toRadians((double)i / (double)ingredients.size() * 360.0 + 180.0);
            builder.addSlot(RecipeIngredientRole.INPUT, 42 + (int)(-42.0 * Math.sin(a)), 42 + (int)(42.0 * Math.cos(a))).addIngredients(ingredient);
            ++i;
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 42, 26).addItemStack(BINDER);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 42, 42).addItemStack(this.container);
        builder.addSlot(RecipeIngredientRole.INPUT, 42, 60).addIngredients(ECIngredientTypes.ELEMENT, this.getElementTypeIngredients(recipe));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 116, 42).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }
}

