/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.element.synthesis;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.AbstractECRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;

public class VibrationRecipeCategory
extends AbstractECRecipeCategory<IngredientElementType> {
    public static final String NAME = "vibration";
    private static final ResourceLocation TEXTURE = ElementalCraftApi.createRL("textures/gui/overlay/vibration.png");
    private static final ItemStack VIBRATION_SYNTHESIZER = new ItemStack((ItemLike)ECBlocks.VIBRATION_SYNTHESIZER.get());
    private static final List<ItemStack> CONTAINERS = List.of(new ItemStack((ItemLike)ECBlocks.SMALL_CONTAINER.get()), new ItemStack((ItemLike)ECBlocks.CONTAINER.get()), new ItemStack((ItemLike)ECBlocks.AIR_RESERVOIR.get()));
    private final IGuiHelper guiHelper;

    public VibrationRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.vibration", VibrationRecipeCategory.createDrawableStack(guiHelper, VIBRATION_SYNTHESIZER), 61, 54);
        this.addOverlay((IDrawable)guiHelper.createDrawable(TEXTURE, 0, 0, 23, 9), 21, 9);
        this.guiHelper = guiHelper;
    }

    @Nonnull
    public RecipeType<IngredientElementType> getRecipeType() {
        return ECJEIRecipeTypes.VIBRATION;
    }

    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, @NotNull IngredientElementType recipe, @NotNull IFocusGroup focuses) {
        acceptor.addWidget((IRecipeWidget)new VibrationWidget(this.guiHelper, new ScreenPosition(2, 3)));
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull IngredientElementType recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 6, 19).addItemStack(VIBRATION_SYNTHESIZER);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 6, 36).addItemStacks(CONTAINERS);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 45, 6).addIngredient(ECIngredientTypes.ELEMENT, (Object)recipe);
    }

    static class VibrationWidget
    implements IRecipeWidget {
        private final IDrawable[] steps;
        private final ScreenPosition position;
        private int ticks = 0;

        VibrationWidget(IGuiHelper guiHelper, ScreenPosition position) {
            this.steps = new IDrawable[]{guiHelper.createDrawable(TEXTURE, 108, 9, 18, 18), guiHelper.createDrawable(TEXTURE, 90, 9, 18, 18), guiHelper.createDrawable(TEXTURE, 72, 9, 18, 18), guiHelper.createDrawable(TEXTURE, 54, 9, 18, 18), guiHelper.createDrawable(TEXTURE, 36, 9, 18, 18), guiHelper.createDrawable(TEXTURE, 18, 9, 18, 18), guiHelper.createDrawable(TEXTURE, 0, 9, 18, 18)};
            this.position = position;
        }

        @NotNull
        public ScreenPosition getPosition() {
            return this.position;
        }

        public void drawWidget(@NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
            int stepIndex = this.ticks % this.steps.length;
            this.steps[stepIndex].draw(guiGraphics, 0, 0);
        }

        public void tick() {
            ++this.ticks;
            if (this.ticks >= 7) {
                this.ticks = 0;
            }
        }
    }
}

