/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.element.synthesis;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.AbstractECRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;

public class SolarSynthesisRecipeCategory
extends AbstractECRecipeCategory<Ingredient> {
    public static final String NAME = "solar_fire_synthesis";
    private static final ItemStack SOLAR_SYNTHESIZER = new ItemStack((ItemLike)ECBlocks.SOLAR_SYNTHESIZER.get());
    private static final List<ItemStack> CONTAINERS = List.of(new ItemStack((ItemLike)ECBlocks.CONTAINER.get()), new ItemStack((ItemLike)ECBlocks.FIRE_RESERVOIR.get()));

    public SolarSynthesisRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.solar_fire_synthesis", SolarSynthesisRecipeCategory.createDrawableStack(guiHelper, SOLAR_SYNTHESIZER), 84, 66);
        this.addOverlay((IDrawable)guiHelper.createDrawable(ElementalCraftApi.createRL("textures/gui/overlay/solar_fire_synthesis.png"), 0, 0, 49, 54), 8, 4);
    }

    @Nonnull
    public RecipeType<Ingredient> getRecipeType() {
        return ECJEIRecipeTypes.SOLAR_SYNTHESIS;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull Ingredient ingredient, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 0).addIngredients(ingredient);
        builder.addSlot(RecipeIngredientRole.CATALYST, 15, 31).addItemStack(SOLAR_SYNTHESIZER);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 15, 47).addItemStacks(CONTAINERS);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 44).addIngredient(ECIngredientTypes.ELEMENT, (Object)IngredientElementType.fromIngredient(ingredient));
    }
}

