/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.element.synthesis;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.AbstractECRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.DrainingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.FoodWidget;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;

public class CulinaryRecipeCategory
extends AbstractECRecipeCategory<ItemStack> {
    public static final String NAME = "culinary";
    private static final ItemStack CULINARY_SYNTHESIZER = new ItemStack((ItemLike)ECBlocks.CULINARY_SYNTHESIZER.get());
    private static final List<ItemStack> CONTAINERS = List.of(new ItemStack((ItemLike)ECBlocks.CONTAINER.get()), new ItemStack((ItemLike)ECBlocks.WATER_RESERVOIR.get()));
    private final IGuiHelper guiHelper;

    public CulinaryRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.culinary", CulinaryRecipeCategory.createDrawableStack(guiHelper, CULINARY_SYNTHESIZER), 55, 63);
        this.addOverlay((IDrawable)guiHelper.createDrawable(DrainingRecipeCategory.TEXTURE, 0, 0, 36, 9), 2, 20);
        this.guiHelper = guiHelper;
    }

    @Nonnull
    public RecipeType<ItemStack> getRecipeType() {
        return ECJEIRecipeTypes.CULINARY;
    }

    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, @NotNull ItemStack recipe, @NotNull IFocusGroup focuses) {
        acceptor.addWidget((IRecipeWidget)new FoodWidget(this.guiHelper, new ScreenPosition(2, 20)));
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull ItemStack recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addItemStack(recipe);
        builder.addSlot(RecipeIngredientRole.CATALYST, 0, 32).addItemStack(CULINARY_SYNTHESIZER);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 47).addItemStacks(CONTAINERS);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 39, 17).addIngredient(ECIngredientTypes.ELEMENT, (Object)new IngredientElementType(ElementType.WATER, 2));
    }
}

