/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public abstract class AbstractECRecipeCategory<T>
implements IRecipeCategory<T> {
    private final String translationKey;
    private final IDrawable icon;
    private final int width;
    private final int height;
    private final List<Overlay<T>> overlays;

    protected AbstractECRecipeCategory(String translationKey, IDrawable icon, int width, int height) {
        this.translationKey = translationKey;
        this.icon = icon;
        this.width = width;
        this.height = height;
        this.overlays = new ArrayList<Overlay<T>>();
    }

    protected static IDrawable createDrawableStack(IGuiHelper guiHelper, ItemStack stack) {
        return guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    public static void render3D(@Nonnull GuiGraphics guiGraphics, BiConsumer<PoseStack, MultiBufferSource> render) {
        PoseStack poseStack = guiGraphics.pose();
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)poseStack.last().pose());
        modelViewStack.translate(0.0f, 0.0f, 1050.0f);
        modelViewStack.scale(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack stack = new PoseStack();
        stack.translate(0.0f, 0.0f, 1000.0f);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        stack.scale(30.0f, 30.0f, 30.0f);
        Lighting.setupForEntityInInventory();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> render.accept(stack, (MultiBufferSource)bufferSource));
        bufferSource.endBatch();
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
    }

    protected static void setupPose(PoseStack p) {
        p.translate(-1.5, -2.3, 0.0);
        p.mulPose(Axis.XP.rotationDegrees(-30.0f));
        p.mulPose(Axis.YP.rotationDegrees(40.0f));
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)this.translationKey);
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addOverlay(IDrawable overlay, int x, int y) {
        this.addOverlay(overlay, x, y, t -> true);
    }

    public void addOverlay(IDrawable overlay, int x, int y, Predicate<T> condition) {
        this.overlays.add(new Overlay<T>(overlay, x, y, condition));
    }

    public void draw(@Nonnull T recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.overlays.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        for (Overlay<T> overlay : this.overlays) {
            if (!overlay.condition.test(recipe)) continue;
            overlay.drawable.draw(guiGraphics, overlay.x, overlay.y);
        }
        RenderSystem.disableBlend();
    }

    private record Overlay<T>(IDrawable drawable, int x, int y, Predicate<T> condition) {
    }
}

