/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.container.ElementContainerBlock;
import sirttas.elementalcraft.block.container.SmallElementContainerBlock;
import sirttas.elementalcraft.block.container.creative.CreativeElementContainerBlock;
import sirttas.elementalcraft.block.container.reservoir.ReservoirBlock;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.spring.SpringShrineBlock;
import sirttas.elementalcraft.interaction.ECInteractions;
import sirttas.elementalcraft.interaction.ie.IEInteraction;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.PureInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.SpellCraftRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.ExtractionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.AirMillSynthesisRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.CombustionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.CulinaryRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.DrainingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.SolarSynthesisRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.VibrationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.cracking.CrackingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.element.synthesis.cracking.SculkCrackingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.BindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.CrystallizationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.EnchantmentLiquefactionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.InscriptionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.InfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.PurificationRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.ToolInfusionRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.mill.GrindingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.mill.SawingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.shrine.BuddingShrineRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.shrine.MeltingShrineRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.shrine.SpringShrineRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.source.DisplacementRecipeCategory;
import sirttas.elementalcraft.interaction.jei.category.source.SourceBreedingRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.element.ElementIngredientRenderer;
import sirttas.elementalcraft.interaction.jei.ingredient.element.IngredientElementType;
import sirttas.elementalcraft.interaction.jei.ingredient.source.IngredientSource;
import sirttas.elementalcraft.interaction.jei.ingredient.source.SourceIngredientHelper;
import sirttas.elementalcraft.interaction.jei.ingredient.source.SourceIngredientRenderer;
import sirttas.elementalcraft.interaction.jei.ingredient.subtype.ElementStorageSubtypeInterpreter;
import sirttas.elementalcraft.interaction.jei.ingredient.subtype.PureElementHolderSubtypeInterpreter;
import sirttas.elementalcraft.interaction.jei.ingredient.subtype.PureOreSubtypeInterpreter;
import sirttas.elementalcraft.interaction.jei.ingredient.subtype.RuneSubtypeInterpreter;
import sirttas.elementalcraft.interaction.jei.ingredient.subtype.SpellSubtypeInterpreter;
import sirttas.elementalcraft.interaction.mekanism.MekanismInteraction;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.elemental.ElementalItem;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.instrument.enchantment.liquefaction.EnchantmentLiquefactionRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.tag.ECTags;

@JeiPlugin
public class ElementalCraftJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ElementalCraftApi.createRL("main");
    private final Supplier<HolderSet.Named<Item>> spellCastTools = () -> ECTags.Items.getTag(ECTags.Items.SPELL_CAST_TOOLS);
    private final Supplier<HolderSet.Named<Item>> jewelSocketalbes = () -> ECTags.Items.getTag(ECTags.Items.JEWEL_SOCKETABLES);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ECIngredientTypes.ELEMENT, IngredientElementType.all(), (IIngredientHelper)new ElementIngredientHelper(), (IIngredientRenderer)new ElementIngredientRenderer(), IngredientElementType.CODEC);
        registration.register(ECIngredientTypes.SOURCE, IngredientSource.all(), (IIngredientHelper)new SourceIngredientHelper(), (IIngredientRenderer)new SourceIngredientRenderer(), IngredientSource.CODEC);
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registry) {
        registry.registerSubtypeInterpreter((Item)ECItems.SCROLL.get(), (ISubtypeInterpreter)new SpellSubtypeInterpreter());
        registry.registerSubtypeInterpreter((Item)ECItems.PURE_ORE.get(), (ISubtypeInterpreter)new PureOreSubtypeInterpreter());
        registry.registerSubtypeInterpreter((Item)ECItems.RUNE.get(), (ISubtypeInterpreter)new RuneSubtypeInterpreter());
        registry.registerSubtypeInterpreter(((SmallElementContainerBlock)((Object)ECBlocks.SMALL_CONTAINER.get())).asItem(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter(((ElementContainerBlock)ECBlocks.CONTAINER.get()).asItem(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter(((CreativeElementContainerBlock)ECBlocks.CREATIVE_CONTAINER.get()).asItem(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter(((ReservoirBlock)ECBlocks.FIRE_RESERVOIR.get()).asItem(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter(((ReservoirBlock)ECBlocks.WATER_RESERVOIR.get()).asItem(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter(((ReservoirBlock)ECBlocks.EARTH_RESERVOIR.get()).asItem(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter(((ReservoirBlock)ECBlocks.AIR_RESERVOIR.get()).asItem(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter((Item)ECItems.FIRE_HOLDER.get(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter((Item)ECItems.WATER_HOLDER.get(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter((Item)ECItems.EARTH_HOLDER.get(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter((Item)ECItems.AIR_HOLDER.get(), (ISubtypeInterpreter)new ElementStorageSubtypeInterpreter());
        registry.registerSubtypeInterpreter((Item)ECItems.PURE_HOLDER.get(), (ISubtypeInterpreter)new PureElementHolderSubtypeInterpreter());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtractionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrackingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SculkCrackingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CombustionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolarSynthesisRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new DrainingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CulinaryRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new VibrationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new AirMillSynthesisRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ToolInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrystallizationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InscriptionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EnchantmentLiquefactionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PureInfusionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PurificationRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new GrindingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SawingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpellCraftRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new DisplacementRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new BuddingShrineRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingShrineRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpringShrineRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SourceBreedingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.FIRE_FURNACE.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.FIRE_BLAST_FURNACE.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.RUDIMENTARY_EXTRACTOR.get()), new RecipeType[]{ECJEIRecipeTypes.EXTRACTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.EXTRACTOR.get()), new RecipeType[]{ECJEIRecipeTypes.EXTRACTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.IMPROVED_EXTRACTOR.get()), new RecipeType[]{ECJEIRecipeTypes.EXTRACTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.CRACKING_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.CRACKING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.COMBUSTION_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.COMBUSTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SOLAR_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.SOLAR_SYNTHESIS});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.DRAINING_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.DRAINING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.CULINARY_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.CULINARY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.VIBRATION_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.VIBRATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_MILL_SYNTHESIZER.get()), new RecipeType[]{ECJEIRecipeTypes.AIR_MILL_SYNTHESIS});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.INFUSER.get()), new RecipeType[]{ECJEIRecipeTypes.INFUSION, ECJEIRecipeTypes.TOOL_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.BINDER.get()), new RecipeType[]{ECJEIRecipeTypes.BINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.BINDER_IMPROVED.get()), new RecipeType[]{ECJEIRecipeTypes.BINDING, ECJEIRecipeTypes.INFUSION, ECJEIRecipeTypes.TOOL_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.CRYSTALLIZER.get()), new RecipeType[]{ECJEIRecipeTypes.CRYSTALLIZATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.INSCRIBER.get()), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack(ECItems.DRENCHED_IRON_CHISEL), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack(ECItems.SWIFT_ALLOY_CHISEL), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack(ECItems.FIREITE_CHISEL), new RecipeType[]{ECJEIRecipeTypes.INSCRIPTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.ENCHANTMENT_LIQUEFIER.get()), new RecipeType[]{ECJEIRecipeTypes.ENCHANTMENT_LIQUEFACTION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.PURE_INFUSER.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.FIRE_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.WATER_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.EARTH_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.PURE_INFUSION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.PURIFIER.get()), new RecipeType[]{ECJEIRecipeTypes.ORE_PURIFICATION});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.WATER_MILL_GRINDSTONE.get()), new RecipeType[]{ECJEIRecipeTypes.GRINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_MILL_GRINDSTONE.get()), new RecipeType[]{ECJEIRecipeTypes.GRINDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.WATER_MILL_WOOD_SAW.get()), new RecipeType[]{ECJEIRecipeTypes.SAWING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.AIR_MILL_WOOD_SAW.get()), new RecipeType[]{ECJEIRecipeTypes.SAWING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SPELL_DESK.get()), new RecipeType[]{ECJEIRecipeTypes.SPELL_CRAFTING});
        registry.addRecipeCatalyst(new ItemStack(ECItems.EMPTY_RECEPTACLE), new RecipeType[]{ECJEIRecipeTypes.DISPLACEMENT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.BUDDING_SHRINE.get()), new RecipeType[]{ECJEIRecipeTypes.BUDDING_SHRINE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.MELTING_SHRINE.get()), new RecipeType[]{ECJEIRecipeTypes.MELTING_SHRINE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SPRING_SHRINE.get()), new RecipeType[]{ECJEIRecipeTypes.SPRING_SHRINE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SOURCE_BREEDER.get()), new RecipeType[]{ECJEIRecipeTypes.SOURCE_BREEDING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ECBlocks.SOURCE_BREEDER_PEDESTAL.get()), new RecipeType[]{ECJEIRecipeTypes.SOURCE_BREEDING});
        if (ECInteractions.isMekanismActive()) {
            MekanismInteraction.addMillsToCrushing(registry);
        }
        if (ECInteractions.isImmersiveEngineeringActive()) {
            IEInteraction.addMillsToCrushing(registry);
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registry.addRecipes(ECJEIRecipeTypes.EXTRACTION, this.getExtractionRecipes());
        registry.addRecipes(ECJEIRecipeTypes.CRACKING, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.CRACKING));
        registry.addRecipes(ECJEIRecipeTypes.SCULK_CRACKING, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.SCULK_CRACKING));
        registry.addRecipes(ECJEIRecipeTypes.COMBUSTION, ElementalCraftJEIPlugin.getFuels(registry));
        registry.addRecipes(ECJEIRecipeTypes.SOLAR_SYNTHESIS, List.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ECItems.FIRE_LENS.get()})));
        registry.addRecipes(ECJEIRecipeTypes.DRAINING, List.of(new IngredientElementType(ElementType.WATER, 1)));
        registry.addRecipes(ECJEIRecipeTypes.CULINARY, registry.getIngredientManager().getAllItemStacks().stream().filter(s -> s.getFoodProperties(null) != null).sorted(Comparator.comparing(s -> s.getFoodProperties(null).nutrition()).thenComparing(s -> Float.valueOf(s.getFoodProperties(null).saturation()))).toList());
        registry.addRecipes(ECJEIRecipeTypes.VIBRATION, List.of(new IngredientElementType(ElementType.AIR, 1)));
        registry.addRecipes(ECJEIRecipeTypes.AIR_MILL_SYNTHESIS, List.of(new IngredientElementType(ElementType.AIR, 3)));
        registry.addRecipes(ECJEIRecipeTypes.INFUSION, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.INFUSION.get()).stream().map(RecipeHolder::value).filter(r -> !(r instanceof ToolInfusionRecipe)).toList());
        registry.addRecipes(ECJEIRecipeTypes.TOOL_INFUSION, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ECRecipeTypes.INFUSION.get()).stream().map(RecipeHolder::value).filter(ToolInfusionRecipe.class::isInstance).toList());
        registry.addRecipes(ECJEIRecipeTypes.BINDING, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.BINDING));
        registry.addRecipes(ECJEIRecipeTypes.CRYSTALLIZATION, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.CRYSTALLIZATION));
        registry.addRecipes(ECJEIRecipeTypes.INSCRIPTION, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.INSCRIPTION));
        registry.addRecipes(ECJEIRecipeTypes.ENCHANTMENT_LIQUEFACTION, this.getEnchantmentLiquefactionRecipes(registry));
        registry.addRecipes(ECJEIRecipeTypes.PURE_INFUSION, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.PURE_INFUSION));
        registry.addRecipes(ECJEIRecipeTypes.GRINDING, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.GRINDING));
        registry.addRecipes(ECJEIRecipeTypes.SAWING, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.SAWING));
        registry.addRecipes(ECJEIRecipeTypes.SPELL_CRAFTING, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.SPELL_CRAFT));
        registry.addRecipes(ECJEIRecipeTypes.ORE_PURIFICATION, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.ORE_PURIFICATION));
        registry.addRecipes(RecipeTypes.ANVIL, this.createCastToolsAnvilRecipes(registry.getVanillaRecipeFactory()));
        registry.addRecipes(RecipeTypes.ANVIL, this.createJewelsAnvilRecipes(registry.getVanillaRecipeFactory()));
        registry.addRecipes(ECJEIRecipeTypes.DISPLACEMENT, ElementType.ALL_VALID);
        registry.addRecipes(ECJEIRecipeTypes.BUDDING_SHRINE, List.of(BuddingShrineBlock.CrystalType.values()));
        registry.addRecipes(ECJEIRecipeTypes.MELTING_SHRINE, this.getRecipes(recipeManager, (Supplier)ECRecipeTypes.MELTING));
        registry.addRecipes(ECJEIRecipeTypes.SPRING_SHRINE, List.of((SpringShrineBlock)ECBlocks.SPRING_SHRINE.get()));
        registry.addRecipes(ECJEIRecipeTypes.SOURCE_BREEDING, List.of((ElementalItem)ECItems.FIRE_SOURCE_SEED.get(), (ElementalItem)ECItems.WATER_SOURCE_SEED.get(), (ElementalItem)ECItems.EARTH_SOURCE_SEED.get(), (ElementalItem)ECItems.AIR_SOURCE_SEED.get()));
    }

    @NotNull
    private static List<IJeiFuelingRecipe> getFuels(@NotNull IRecipeRegistration registry) {
        return registry.getIngredientManager().getAllItemStacks().stream().mapMulti((stack, consumer) -> {
            int burnTime = stack.getBurnTime(null);
            if (burnTime > 0) {
                consumer.accept(new FuelingRecipe(List.of(stack), burnTime));
            }
        }).sorted(Comparator.comparingInt(IJeiFuelingRecipe::getBurnTime)).toList();
    }

    private List<ExtractionRecipeCategory.ExtractionRecipe> getExtractionRecipes() {
        ArrayList<ExtractionRecipeCategory.ExtractionRecipe> list = new ArrayList<ExtractionRecipeCategory.ExtractionRecipe>();
        for (ElementType elementType : ElementType.ALL_VALID) {
            list.add(new ExtractionRecipeCategory.ExtractionRecipe(new IngredientElementType(elementType, 1), new ItemStack((ItemLike)ECBlocks.RUDIMENTARY_EXTRACTOR.get()), List.of(new ItemStack((ItemLike)ECBlocks.CONTAINER.get()), new ItemStack((ItemLike)ECBlocks.SMALL_CONTAINER.get()))));
            list.add(new ExtractionRecipeCategory.ExtractionRecipe(new IngredientElementType(elementType, 2), new ItemStack((ItemLike)ECBlocks.EXTRACTOR.get()), List.of(new ItemStack((ItemLike)ECBlocks.CONTAINER.get()))));
            list.add(new ExtractionRecipeCategory.ExtractionRecipe(new IngredientElementType(elementType, 3), new ItemStack((ItemLike)ECBlocks.IMPROVED_EXTRACTOR.get()), List.of(new ItemStack((ItemLike)ECBlocks.CONTAINER.get()))));
        }
        return list;
    }

    private List<EnchantmentLiquefactionRecipeCategory.RecipeWrapper> getEnchantmentLiquefactionRecipes(@Nonnull IRecipeRegistration registry) {
        Collection stacks = registry.getIngredientManager().getAllItemStacks();
        return Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().flatMap(e -> IntStream.range(1, ((Enchantment)e.value()).getMaxLevel()).mapToObj(l -> new EnchantmentLiquefactionRecipeCategory.RecipeWrapper(new EnchantmentLiquefactionRecipe((Holder<Enchantment>)e), l, stacks.stream().filter(ItemStack::isEnchantable).filter(s -> s.supportsEnchantment((Holder)e)).toList()))).toList();
    }

    private <C extends RecipeInput, R extends Recipe<C>, T extends net.minecraft.world.item.crafting.RecipeType<R>> List<R> getRecipes(RecipeManager recipeManager, Supplier<T> typeSupplier) {
        return recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)typeSupplier.get()).stream().map(RecipeHolder::value).toList();
    }

    private List<IJeiAnvilRecipe> createCastToolsAnvilRecipes(IVanillaRecipeFactory factory) {
        return Spells.REGISTRY.holders().filter(SpellHelper::isVisible).mapMulti((spell, downstream) -> this.spellCastTools.get().forEach(item -> {
            ItemStack scroll = new ItemStack(ECItems.SCROLL);
            ItemStack stack = new ItemStack(item);
            SpellHelper.setSpell(scroll, (Holder<Spell>)spell);
            SpellHelper.addSpell(stack, (Holder<Spell>)spell);
            downstream.accept(factory.createAnvilRecipe(new ItemStack(item), List.of(scroll), List.of(stack), spell.key().location()));
        })).toList();
    }

    private List<IJeiAnvilRecipe> createJewelsAnvilRecipes(IVanillaRecipeFactory factory) {
        return Jewels.REGISTRY.stream().flatMap(jewel -> this.jewelSocketalbes.get().stream().map(item -> {
            ItemStack stack = new ItemStack(item);
            JewelHelper.setJewel(stack, jewel);
            return factory.createAnvilRecipe(new ItemStack(item), List.of(new ItemStack((ItemLike)jewel)), List.of(stack), jewel.getKey());
        })).toList();
    }
}

