/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.ie.recipe;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.recipe.instrument.io.SimpleIOInstrumentRecipeInput;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;

public class IECrusherRecipeWrapper
implements IGrindingRecipe {
    private final CrusherRecipe crushingRecipe;

    public IECrusherRecipeWrapper(CrusherRecipe crushingRecipe) {
        this.crushingRecipe = crushingRecipe;
    }

    @Override
    public int getElementAmount() {
        return 1000;
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.crushingRecipe.getIngredients();
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider provider) {
        return this.crushingRecipe.getResultItem(provider);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return this.crushingRecipe.getSerializer();
    }

    @Override
    public boolean matches(@NotNull ItemStack stack, @NotNull Level level) {
        return this.crushingRecipe.input.test(stack) && IGrindingRecipe.super.matches(stack, level);
    }

    @Override
    @Nonnull
    @NotNull
    public ItemStack assemble(@Nonnull SimpleIOInstrumentRecipeInput input, @Nonnull HolderLookup.Provider provider) {
        int luck = this.getLuck(input);
        ItemStack result = IGrindingRecipe.super.assemble(input, provider);
        RandomSource rand = this.getRandomSource(input);
        this.crushingRecipe.secondaryOutputs.forEach(output -> {
            ItemStack stack = output.stack().get();
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)result) && rand.nextFloat() < output.chance() * (float)luck) {
                result.grow(stack.getCount());
            }
        });
        return result;
    }
}

