/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.ie.injector;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.factory.AbstractPureOreRecipeFactory;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractIEPureOreRecipeFactory<T extends IESerializableRecipe>
extends AbstractPureOreRecipeFactory<RecipeInput, IESerializableRecipe> {
    private final Class<T> recipeClass;

    protected AbstractIEPureOreRecipeFactory(@Nonnull RecipeManager recipeManager, RecipeType<T> recipeType, @Nonnull Class<T> recipeClass) {
        super(recipeManager, recipeType);
        this.recipeClass = recipeClass;
    }

    @Override
    public final IESerializableRecipe create(@NotNull RegistryAccess registry, @NotNull IESerializableRecipe recipe, @NotNull Ingredient ingredient) {
        if (this.recipeClass.isInstance(recipe)) {
            return this.buildIERecipe((IESerializableRecipe)this.recipeClass.cast(recipe), ingredient);
        }
        if (recipe instanceof GeneratedListRecipe) {
            GeneratedListRecipe generatedListRecipe = (GeneratedListRecipe)recipe;
            return AbstractIEPureOreRecipeFactory.streamSubRecipes(generatedListRecipe).map(r -> this.create(registry, (IESerializableRecipe)r, ingredient)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    protected abstract T buildIERecipe(T var1, Ingredient var2);

    @Override
    public final boolean filter(RecipeHolder<IESerializableRecipe> holder, ItemStack stack) {
        IESerializableRecipe recipe = (IESerializableRecipe)holder.value();
        ResourceLocation id = holder.id();
        try {
            if (!stack.is(ECTags.Items.PURE_ORES_SOURCES_RAW_MATERIALS)) {
                return false;
            }
            if (this.recipeClass.isInstance(recipe)) {
                return this.filterIERecipe((IESerializableRecipe)this.recipeClass.cast(recipe), stack);
            }
            if (recipe instanceof GeneratedListRecipe) {
                GeneratedListRecipe generatedListRecipe = (GeneratedListRecipe)recipe;
                return AbstractIEPureOreRecipeFactory.streamSubRecipes(generatedListRecipe).anyMatch(r -> this.filter((RecipeHolder<IESerializableRecipe>)new RecipeHolder(id, (Recipe)r), stack));
            }
        }
        catch (Exception e) {
            ElementalCraftApi.LOGGER.warn("Error while filtering immersive engineering recipe {} for pure ore", (Object)id, (Object)e);
        }
        return false;
    }

    @NotNull
    private static Stream<IESerializableRecipe> streamSubRecipes(GeneratedListRecipe<?, ?> generatedListRecipe) {
        List subRecipes = generatedListRecipe.getSubRecipes();
        if (subRecipes == null || subRecipes.isEmpty()) {
            return Stream.empty();
        }
        return subRecipes.stream().mapMulti(ElementalCraftUtils.cast(IESerializableRecipe.class));
    }

    protected abstract boolean filterIERecipe(T var1, ItemStack var2);
}

