/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.input;

import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.input.ECKeyMappings;
import sirttas.elementalcraft.spell.ChangeSpellPayload;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.tag.ECTags;

@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class InputHandler {
    private InputHandler() {
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isShiftKeyDown()) {
            InputHandler.getFirstSpellCastTool(EntityHelper.handStream((LivingEntity)player)).ifPresent(stack -> {
                int index = SpellHelper.getSelected(stack);
                if (event.getScrollDeltaY() > 0.0) {
                    InputHandler.setSelectedSpell(player, stack, index - 1);
                    event.setCanceled(true);
                } else if (event.getScrollDeltaY() < 0.0) {
                    InputHandler.setSelectedSpell(player, stack, index + 1);
                    event.setCanceled(true);
                }
            });
        }
    }

    @Nonnull
    private static Optional<ItemStack> getFirstSpellCastTool(Stream<ItemStack> player) {
        return player.filter(i -> i.is(ECTags.Items.SPELL_CAST_TOOLS)).findFirst();
    }

    private static void setSelectedSpell(LocalPlayer player, ItemStack stack, int i) {
        SpellHelper.setSelected(stack, i);
        player.displayClientMessage(((Spell)SpellHelper.getSpell(stack).value()).getDisplayName(), true);
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeSpellPayload(i), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof LocalPlayer) {
            LocalPlayer player2 = (LocalPlayer)player;
            if (player2.level().isClientSide && player2 == Minecraft.getInstance().player) {
                InputHandler.getFirstSpellCastTool(EntityHelper.handStream((LivingEntity)player2)).ifPresent(stack -> {
                    int index = 0;
                    for (KeyMapping key : ECKeyMappings.CHANGE_TO_SPELL) {
                        if (!key.isUnbound() && key.consumeClick() && SpellHelper.getSpellList(stack).getSpells().size() > index) {
                            InputHandler.setSelectedSpell(player2, stack, index);
                        }
                        ++index;
                    }
                });
            }
        }
    }
}

