/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import sirttas.elementalcraft.input.ECKeyConflictContext;

@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class ECKeyMappings {
    public static final List<KeyMapping> CHANGE_TO_SPELL = List.of(ECKeyMappings.spellChangeKey(1), ECKeyMappings.spellChangeKey(2), ECKeyMappings.spellChangeKey(3), ECKeyMappings.spellChangeKey(4), ECKeyMappings.spellChangeKey(5), ECKeyMappings.spellChangeKey(6), ECKeyMappings.spellChangeKey(7), ECKeyMappings.spellChangeKey(8), ECKeyMappings.spellChangeKey(9), ECKeyMappings.spellChangeKey(0));

    private ECKeyMappings() {
    }

    private static KeyMapping key(String name, int keyCode) {
        return ECKeyMappings.key(name, (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, keyCode);
    }

    private static KeyMapping spellChangeKey(int number) {
        return ECKeyMappings.key("change_spell." + number, ECKeyConflictContext.CHANGE_SPELL, KeyModifier.SHIFT, 48 + number);
    }

    private static KeyMapping key(String name, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode) {
        return new KeyMapping("key.elementalcraft." + name, keyConflictContext, keyModifier, InputConstants.Type.KEYSYM.getOrCreate(keyCode), "key.categories.elementalcraft");
    }

    @SubscribeEvent
    public static void registerKeyBinds(RegisterKeyMappingsEvent event) {
        for (KeyMapping key : CHANGE_TO_SPELL) {
            event.register(key);
        }
    }
}

