/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.infusion.tool;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.enchanting.GetEnchantmentLevelEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import sirttas.elementalcraft.api.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

@EventBusSubscriber(modid="elementalcraft")
public class ToolInfusionHandler {
    private ToolInfusionHandler() {
    }

    @SubscribeEvent
    public static void addInfusionAttributes(ItemAttributeModifierEvent event) {
        ToolInfusionHelper.getInfusionAttribute(event.getItemStack()).forEach(i -> event.addModifier(i.attribute(), i.modifier(), i.slotGroup()));
    }

    @SubscribeEvent
    public static void addInfusionLevel(GetEnchantmentLevelEvent event) {
        ItemEnchantments.Mutable enchantments = event.getEnchantments();
        ToolInfusionHelper.getAllInfusionEnchantments(event.getStack()).forEach((enchantment, level) -> enchantments.set(enchantment, enchantments.getLevel(enchantment) + level));
    }

    @SubscribeEvent
    public static void addInfusionTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Holder<ToolInfusion> infusion = ToolInfusionHelper.getInfusion(stack);
        if (infusion.value() == ToolInfusion.NONE) {
            return;
        }
        List tooltip = event.getToolTip();
        int index = IntStream.range(0, tooltip.size()).filter(i -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals(((Component)tooltip.get(i)).getString())).findFirst().orElse(tooltip.size());
        tooltip.addAll(index, ((ToolInfusion)infusion.value()).getTooltipInformation());
    }
}

