/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorageWrapper;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorsSaveData;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.ShrineElementStorage;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeBlockItem;
import sirttas.elementalcraft.client.LevelRenderHandler;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.entity.player.PlayerElementStorage;
import sirttas.elementalcraft.gui.GuiHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.air.TranslocationSpell;
import sirttas.elementalcraft.spell.tick.SpellCooldownItemDecorator;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class GuiHandler {
    public static final Material TRANSLOCATION_ANCHOR_MARKER = ECRendererHelper.getBlockMaterial("gui/translocation_anchor_marker");

    private GuiHandler() {
    }

    @SubscribeEvent
    public static void registerItemDecorators(RegisterItemDecorationsEvent event) {
        SpellCooldownItemDecorator spellCooldown = new SpellCooldownItemDecorator();
        event.register((ItemLike)ECItems.SCROLL.get(), (IItemDecorator)spellCooldown);
        event.register((ItemLike)ECItems.FOCUS.get(), (IItemDecorator)spellCooldown);
        event.register((ItemLike)ECItems.STAFF.get(), (IItemDecorator)spellCooldown);
    }

    @SubscribeEvent
    public static void onDrawScreenPost(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, ElementalCraftApi.createRL("gauge"), GuiHandler::drawGauge);
        event.registerAbove(VanillaGuiLayers.CAMERA_OVERLAYS, ElementalCraftApi.createRL("translocation_anchor_marker"), GuiHandler::drawAnchors);
        event.registerBelow(ElementalCraftApi.createRL("translocation_anchor_marker"), ElementalCraftApi.createRL("single_translocation_anchor_marker"), GuiHandler::drawAnchor);
    }

    public static void drawGauge(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        RenderSystem.enableBlend();
        Spell spell = GuiHandler.getSpell();
        int i = 0;
        for (ISingleElementStorage storage : GuiHandler.getElementStorage((Player)player)) {
            ElementType type = storage.getElementType();
            GuiHandler.renderElementGauge(guiGraphics, Minecraft.getInstance().font, storage.getElementAmount(), storage.getElementCapacity(), type, i);
            if (storage instanceof ShrineElementStorage) {
                ShrineElementStorage shrineStorage = (ShrineElementStorage)storage;
                GuiHandler.renderShrineCheck(guiGraphics, storage, shrineStorage);
            } else if (spell.isValid() && spell.getElementType() == type && i == 0 && GuiHandler.isPlayerOwned((Player)player, storage)) {
                GuiHandler.renderSpellCheck(guiGraphics, player, spell);
            }
            ++i;
        }
        RenderSystem.disableBlend();
    }

    private static boolean isPlayerOwned(Player player, ISingleElementStorage storage) {
        SingleElementStorageWrapper wrapper;
        IElementStorage iElementStorage;
        if (storage instanceof SingleElementStorageWrapper && (iElementStorage = (wrapper = (SingleElementStorageWrapper)storage).getParent()) instanceof PlayerElementStorage) {
            PlayerElementStorage playerStorage = (PlayerElementStorage)iElementStorage;
            return player.equals((Object)playerStorage.getPlayer());
        }
        return false;
    }

    public static void drawAnchors(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        Matrix4f worldMatrix = LevelRenderHandler.getWorldMatrix();
        if (worldMatrix == null || player == null || !TranslocationSpell.holdsTranslocation((Player)player) || TranslocationAnchorsSaveData.CLIENT_SET.isEmpty()) {
            return;
        }
        BlockPos targetAnchor = TranslocationSpell.getTargetAnchor((Entity)player, TranslocationAnchorsSaveData.CLIENT_SET);
        float range = ((TranslocationSpell)Spells.TRANSLOCATION.get()).getRange((Entity)player);
        float rangeSq = range * range;
        float falloffSq = range / 2.0f * (range / 2.0f);
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 playerPos = player.position();
        MultiBufferSource.BufferSource buffer = GuiHandler.createBufferSource();
        RenderSystem.enableBlend();
        for (BlockPos anchor : TranslocationAnchorsSaveData.CLIENT_SET) {
            Vector4f v;
            Vec3 center = Vec3.atCenterOf((Vec3i)anchor);
            double distanceSq = center.distanceToSqr(playerPos);
            if (!(distanceSq <= (double)rangeSq) || (v = GuiHandler.getPositionInScreen(worldMatrix, cameraPos, center)).z() <= 0.0f || v.z() >= 1.0f) continue;
            GuiHandler.drawAnchor(guiGraphics.pose(), guiGraphics.guiWidth(), guiGraphics.guiHeight(), anchor.equals((Object)targetAnchor) ? 1.5f : GuiHandler.getAnchorScale(falloffSq, (float)distanceSq), buffer, v);
        }
        RenderSystem.disableBlend();
        buffer.endBatch();
    }

    public static void drawAnchor(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        Matrix4f worldMatrix = LevelRenderHandler.getWorldMatrix();
        if (worldMatrix == null || player == null || TranslocationAnchorsSaveData.CLIENT_SET.isEmpty()) {
            return;
        }
        BlockPos anchor = TranslocationShrineUpgradeBlockItem.getTargetAnchor((Player)player);
        if (anchor == null || !TranslocationAnchorsSaveData.CLIENT_SET.contains(anchor)) {
            return;
        }
        float range = ((TranslocationSpell)Spells.TRANSLOCATION.get()).getRange(null);
        float rangeSq = range * range;
        Vec3 center = Vec3.atCenterOf((Vec3i)anchor);
        double distanceSq = center.distanceToSqr(player.position());
        if (distanceSq > (double)rangeSq) {
            return;
        }
        Vector4f v = GuiHandler.getPositionInScreen(worldMatrix, Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), center);
        if (v.z() <= 0.0f || v.z() >= 1.0f) {
            return;
        }
        MultiBufferSource.BufferSource buffer = GuiHandler.createBufferSource();
        RenderSystem.enableBlend();
        GuiHandler.drawAnchor(guiGraphics.pose(), guiGraphics.guiWidth(), guiGraphics.guiHeight(), 1.5f, buffer, v);
        RenderSystem.disableBlend();
        buffer.endBatch();
    }

    @NotNull
    private static MultiBufferSource.BufferSource createBufferSource() {
        return MultiBufferSource.immediate((ByteBufferBuilder)Tesselator.getInstance().buffer);
    }

    private static void drawAnchor(PoseStack poseStack, int width, int height, float scale, MultiBufferSource.BufferSource buffer, Vector4f v) {
        float w = (float)width / 2.0f;
        float h = (float)height / 2.0f;
        float x = Mth.clamp((float)(w + v.x() * w), (float)16.0f, (float)((float)width - 16.0f));
        float y = Mth.clamp((float)(h - v.y() * h), (float)16.0f, (float)((float)height - 16.0f));
        poseStack.pushPose();
        poseStack.translate(x, y, 1.0f);
        poseStack.scale(0.25f, 0.25f, 1.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate(-64.0f, -64.0f, 1.0f);
        ECRendererHelper.renderIcon(poseStack, (MultiBufferSource)buffer, TRANSLOCATION_ANCHOR_MARKER, 128, 128);
        poseStack.popPose();
    }

    private static float getAnchorScale(float falloffSq, float distanceSq) {
        return Mth.clamp((float)(1.0f - distanceSq / falloffSq), (float)0.2f, (float)1.0f);
    }

    @Nonnull
    private static Vector4f getPositionInScreen(Matrix4f worldMatrix, Vec3 cameraPos, Vec3 center) {
        Vector4f v = new Vector4f((float)(center.x - cameraPos.x), (float)(center.y - cameraPos.y), (float)(center.z - cameraPos.z), 1.0f);
        worldMatrix.transform(v);
        v.div((Vector4fc)v);
        return v;
    }

    private static List<ISingleElementStorage> getElementStorage(Player player) {
        IJewelHandler jewelHandler;
        Optional<IElementStorage> holder;
        Minecraft minecraft = Minecraft.getInstance();
        HitResult result = minecraft.hitResult;
        if (result != null && minecraft.options.getCameraType().isFirstPerson()) {
            List<ISingleElementStorage> storages;
            BlockPos pos = result.getType() == HitResult.Type.BLOCK ? ((BlockHitResult)result).getBlockPos() : null;
            IElementStorage storage = pos != null ? (IElementStorage)player.level().getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, pos, null) : null;
            List<ISingleElementStorage> list = storages = storage != null && (storage.doesRenderGauge(player) || GuiHelper.showDebugInfo()) ? GuiHandler.splitStorage(storage) : Collections.emptyList();
            if (!storages.isEmpty()) {
                return storages;
            }
        }
        if ((holder = EntityHelper.handStream((LivingEntity)player).map(stack -> (IElementStorage)stack.getCapability(ElementalCraftCapabilities.ElementStorage.ITEM)).filter(Objects::nonNull).findFirst()).isPresent()) {
            return GuiHandler.splitStorage(holder.get());
        }
        IElementStorage playerStorage = (IElementStorage)player.getCapability(ElementalCraftCapabilities.ElementStorage.ENTITY);
        if (playerStorage == null) {
            return Collections.emptyList();
        }
        ElementType spellElementType = EntityHelper.handStream((LivingEntity)player).map(stack -> {
            if (!stack.isEmpty() && stack.getItem() instanceof ISpellHolder) {
                return ((Spell)SpellHelper.getSpell(stack).value()).getElementType();
            }
            return ElementType.NONE;
        }).filter(type -> type != ElementType.NONE).findFirst().orElse(ElementType.NONE);
        ArrayList<ElementType> list = new ArrayList<ElementType>(4);
        if (spellElementType != ElementType.NONE) {
            list.add(spellElementType);
        }
        if ((jewelHandler = (IJewelHandler)player.getCapability(IJewelHandler.CAPABILITY)) != null) {
            jewelHandler.getActiveJewels().stream().map(Jewel::getElementType).distinct().filter(type -> type != ElementType.NONE && type != spellElementType).forEach(list::add);
        }
        return GuiHandler.splitStorage(playerStorage, list);
    }

    private static List<ISingleElementStorage> splitStorage(IElementStorage storage) {
        if (storage instanceof ISingleElementStorage) {
            ISingleElementStorage singleElementStorage = (ISingleElementStorage)storage;
            return Collections.singletonList(singleElementStorage);
        }
        return GuiHandler.splitStorage(storage, ElementType.ALL_VALID);
    }

    private static List<ISingleElementStorage> splitStorage(IElementStorage storage, List<ElementType> elementTypes) {
        if (storage instanceof ISingleElementStorage) {
            ISingleElementStorage singleElementStorage = (ISingleElementStorage)storage;
            return elementTypes.contains(singleElementStorage.getElementType()) ? List.of(singleElementStorage) : Collections.emptyList();
        }
        return elementTypes.stream().mapMulti((type, downstream) -> downstream.accept(storage.forElement((ElementType)type))).filter(s -> s.getElementCapacity() > 0).toList();
    }

    private static Spell getSpell() {
        return EntityHelper.handStream((LivingEntity)Minecraft.getInstance().player).map(stack -> {
            if (!stack.isEmpty() && stack.getItem() instanceof ISpellHolder) {
                return SpellHelper.getSpell(stack);
            }
            return Spells.NONE;
        }).filter(SpellHelper::isValid).findFirst().map(Holder::value).orElseGet((Supplier<Spell>)Spells.NONE);
    }

    private static void renderElementGauge(GuiGraphics guiGraphics, Font font, int element, int max, ElementType type, int index) {
        GuiHelper.renderElementGauge(guiGraphics, font, GuiHandler.getXOffset() - 32 - 20 * index, GuiHandler.getYOffset() - 8, element, max, type);
    }

    public static int getYOffset() {
        return Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetX.get();
    }

    public static int getXOffset() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 + (Integer)ECConfig.CLIENT.gaugeOffsetY.get();
    }

    private static void renderShrineCheck(GuiGraphics guiGraphics, ISingleElementStorage storage, ShrineElementStorage shrineStorage) {
        AbstractShrineBlockEntity shrine = shrineStorage.getShrine();
        if (shrine.isRunning()) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.VALID);
        } else if (storage.getElementAmount() >= shrine.getConsumeAmount()) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.PAUSED);
        } else {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.INVALID);
        }
    }

    private static void renderSpellCheck(GuiGraphics guiGraphics, LocalPlayer player, Spell spell) {
        boolean canCast = spell.consume((Entity)player, true);
        boolean isInCooldown = SpellTickHelper.hasCooldown((Entity)player, spell);
        if (canCast && !isInCooldown) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.VALID);
        } else if (isInCooldown) {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.PAUSED);
        } else {
            GuiHandler.renderCheck(guiGraphics, GuiHelper.Check.INVALID);
        }
    }

    private static void renderCheck(GuiGraphics guiGraphics, GuiHelper.Check valid) {
        GuiHelper.renderCheck(guiGraphics, valid, GuiHandler.getXOffset() - 21, GuiHandler.getYOffset() + 3);
    }
}

