/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.event;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import org.apache.commons.lang3.StringUtils;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.jewel.JewelItem;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.SpellList;
import sirttas.elementalcraft.tag.ECTags;

@EventBusSubscriber(modid="elementalcraft")
public class EnchantmentHandler {
    private EnchantmentHandler() {
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        Item result2;
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        String name = event.getName();
        SpellList spellList = SpellHelper.getSpellList(left);
        if (left.is(ECTags.Items.SPELL_CAST_TOOLS) && right.is(ECItems.SCROLL) && !spellList.isFull()) {
            ItemStack result2 = left.copy();
            int n = 4 * (spellList.count() + 1);
            if (EnchantmentHandler.applyRename(left, result2, name)) {
                ++n;
            }
            SpellHelper.addSpell(result2, SpellHelper.getSpell(right));
            event.setCost((long)n);
            event.setOutput(result2);
        } else if (left.is(ECTags.Items.JEWEL_SOCKETABLES) && (result2 = right.getItem()) instanceof JewelItem) {
            JewelItem jewelItem = (JewelItem)result2;
            if (JewelHelper.getJewel(left) == null) {
                result2 = left.copy();
                int n = 10;
                if (EnchantmentHandler.applyRename(left, (ItemStack)result2, name)) {
                    ++n;
                }
                JewelHelper.setJewel((ItemStack)result2, jewelItem.getJewel());
                event.setCost((long)n);
                event.setOutput((ItemStack)result2);
            }
        }
    }

    private static boolean applyRename(ItemStack input, ItemStack result, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            if (input.has(DataComponents.CUSTOM_NAME)) {
                result.remove(DataComponents.CUSTOM_NAME);
                return true;
            }
        } else if (!name.equals(input.getHoverName().getString())) {
            result.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
            return true;
        }
        return false;
    }
}

