/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity.player;

import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;
import sirttas.elementalcraft.spell.tick.SpellTickCooldownPayload;

public class PlayerSpellTickManager
implements ISpellTickManager {
    private final ServerPlayer player;
    private final ISpellTickManager delegate;

    public PlayerSpellTickManager(ServerPlayer player, ISpellTickManager delegate) {
        this.player = player;
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public List<AbstractSpellInstance> getSpellInstances() {
        return this.delegate.getSpellInstances();
    }

    @Override
    public void addSpellInstance(AbstractSpellInstance instance) {
        this.delegate.addSpellInstance(instance);
    }

    @Override
    public void startCooldown(Spell spell) {
        this.delegate.startCooldown(spell);
        PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new SpellTickCooldownPayload(spell), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public float getCooldown(Spell spell, float partialTick) {
        return this.delegate.getCooldown(spell, partialTick);
    }

    @Override
    public void tick() {
        this.delegate.tick();
    }
}

