/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity.player;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.interaction.ECInteractions;
import sirttas.elementalcraft.interaction.curios.CuriosInteractions;

public class PlayerElementStorage
implements IElementStorage {
    private int tickCount = -1;
    private final Player player;
    private final List<IElementStorage> storages = new ArrayList<IElementStorage>();

    public PlayerElementStorage(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getElementAmount(ElementType type) {
        return this.getStorages().stream().mapToInt(storage -> storage.getElementAmount(type)).sum();
    }

    @Override
    public int getElementCapacity(ElementType type) {
        return this.getStorages().stream().mapToInt(storage -> storage.getElementCapacity(type)).sum();
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        AtomicInteger remaining = new AtomicInteger(count);
        this.getStorages().forEach(storage -> {
            if (storage.getElementCapacity(type) > 0) {
                remaining.set(storage.insertElement(remaining.get(), type, simulate));
            }
        });
        return remaining.get();
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        AtomicInteger extracted = new AtomicInteger(0);
        this.getStorages().forEach(storage -> {
            if (storage.getElementCapacity(type) > 0) {
                int e = extracted.get();
                extracted.set(e + storage.extractElement(count - e, type, simulate));
            }
        });
        return extracted.get();
    }

    @Override
    public boolean usableInInventory() {
        return true;
    }

    @Override
    public void fill() {
        this.getStorages().forEach(IElementStorage::fill);
    }

    @Override
    public void fill(ElementType type) {
        this.getStorages().forEach(storage -> storage.fill(type));
    }

    private List<IElementStorage> getStorages() {
        if (this.tickCount != this.player.tickCount) {
            this.storages.clear();
            Inventory inventory = this.player.getInventory();
            for (int i2 = 0; i2 < inventory.getContainerSize(); ++i2) {
                IElementStorage storage = (IElementStorage)inventory.getItem(i2).getCapability(ElementalCraftCapabilities.ElementStorage.ITEM);
                if (storage == null || !storage.usableInInventory()) continue;
                this.storages.add(storage);
            }
            if (ECInteractions.isCuriosActive()) {
                CuriosInteractions.getHolders((LivingEntity)this.player).forEach(i -> {
                    IElementStorage storage = (IElementStorage)i.getCapability(ElementalCraftCapabilities.ElementStorage.ITEM);
                    if (storage != null && storage.usableInInventory()) {
                        this.storages.add(storage);
                    }
                });
            }
            this.tickCount = this.player.tickCount;
        }
        return this.storages;
    }
}

