/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity.goal;

import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

public class CastSpellGoal
extends Goal {
    private final PathfinderMob caster;
    private final Spell spell;

    public CastSpellGoal(PathfinderMob caster, Spell spell) {
        this.caster = caster;
        this.spell = spell;
    }

    private void cast() {
        LivingEntity target = this.caster.getTarget();
        if (target == null) {
            return;
        }
        InteractionResult result = this.spell.castOnEntity((Entity)this.caster, (Entity)target);
        if (!result.consumesAction()) {
            result = this.spell.castOnSelf((Entity)this.caster);
        }
        if (result.consumesAction()) {
            Level level = this.caster.level();
            this.spell.consume((Entity)this.caster, false);
            if (!level.isClientSide) {
                SpellTickHelper.startCooldown((Entity)this.caster, this.spell);
            }
        }
    }

    public void start() {
        this.cast();
    }

    public void tick() {
        this.cast();
    }

    public boolean canUse() {
        return this.caster.getTarget() != null && SpellTickHelper.hasCooldown((Entity)this.caster, this.spell);
    }
}

