/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class EntityHelper {
    private EntityHelper() {
    }

    public static Stream<ItemStack> handStream(LivingEntity entity) {
        return Stream.of(entity.getMainHandItem(), entity.getOffhandItem());
    }

    public static HitResult rayTrace(Entity entity) {
        LivingEntity livingEntity;
        AttributeInstance reach;
        double range = 5.0;
        if (entity instanceof LivingEntity && (reach = (livingEntity = (LivingEntity)entity).getAttribute(Attributes.BLOCK_INTERACTION_RANGE)) != null) {
            range = reach.getValue();
        }
        return EntityHelper.rayTrace(entity, range);
    }

    public static HitResult rayTrace(Entity entity, double range) {
        Vec3 eyePos = entity.getEyePosition(1.0f);
        Vec3 look = entity.getViewVector(1.0f);
        Vec3 rayVector = eyePos.add(look.x * range, look.y * range, look.z * range);
        BlockHitResult blockResult = entity.level().clip(new ClipContext(eyePos, rayVector, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
        EntityHitResult entityResult = ProjectileUtil.getEntityHitResult((Level)entity.level(), (Entity)entity, (Vec3)eyePos, (Vec3)rayVector, (AABB)entity.getBoundingBox().expandTowards(look.scale(range)).inflate(1.0, 1.0, 1.0), e -> !e.isSpectator() && e.isPickable());
        return entityResult != null && entityResult.getLocation().subtract(eyePos).length() <= blockResult.getLocation().subtract(eyePos).length() ? entityResult : blockResult;
    }

    public static boolean isHostile(Entity entity) {
        return entity instanceof Enemy;
    }

    public static boolean spawnMob(ServerLevel level, BlockPos pos) {
        return WeightedRandomList.create(level.getChunkSource().getGenerator().getMobsAt(level.getBiome(pos), level.structureManager(), MobCategory.MONSTER, pos).unwrap().stream().filter(data -> EntityHelper.canSpawn(level, pos, data)).toList()).getRandom(level.random).map(data -> EntityHelper.doSpawn(level, pos, data)).orElse(false);
    }

    private static boolean doSpawn(ServerLevel level, BlockPos pos, MobSpawnSettings.SpawnerData data) {
        Entity entity = data.type.create((Level)level);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), level.random.nextFloat() * 360.0f, 0.0f);
            EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.SPAWNER, null);
            level.addFreshEntityWithPassengers((Entity)mob);
            mob.spawnAnim();
            return true;
        }
        return false;
    }

    private static boolean canSpawn(ServerLevel level, BlockPos pos, MobSpawnSettings.SpawnerData data) {
        EntityType entityType = data.type;
        if (entityType.canSummon()) {
            SpawnPlacementType placementType = SpawnPlacements.getPlacementType((EntityType)entityType);
            if (!placementType.isSpawnPositionOk((LevelReader)level, pos, entityType)) {
                return false;
            }
            if (!SpawnPlacements.checkSpawnRules((EntityType)entityType, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)pos, (RandomSource)level.random)) {
                return false;
            }
            return level.noCollision(entityType.getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5));
        }
        return false;
    }

    public static boolean isFighting(Entity entity) {
        return EntityHelper.isFighting(entity, 20);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFighting(Entity entity, int ticks) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.attackStrengthTicker >= ticks) return false;
        return true;
    }

    public static void dropAtFeet(@NotNull Level level, @NotNull Entity entity, @NotNull ItemStack stack) {
        level.addFreshEntity((Entity)new ItemEntity(level, entity.getX(), entity.getY() + 0.25, entity.getZ(), stack));
    }
}

