/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import sirttas.elementalcraft.container.menu.IMenuOpenListener;
import sirttas.elementalcraft.data.attachment.ECDataAttachments;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.jewel.handler.JewelHandler;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

@EventBusSubscriber(modid="elementalcraft")
public class EntityHandler {
    private EntityHandler() {
    }

    @SubscribeEvent
    public static void onEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        int fastDraw = ToolInfusionHelper.getFasterDraw(event.getItem());
        if (fastDraw >= 0 && event.getDuration() % fastDraw == 0) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @SubscribeEvent
    public static void onEntityLivingAttack(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.level();
        if (!world.isClientSide && world.getRandom().nextDouble() >= ToolInfusionHelper.getDodge((Entity)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof IMenuOpenListener) {
            IMenuOpenListener listener = (IMenuOpenListener)abstractContainerMenu;
            listener.onOpen(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            ((JewelHandler)player.getData(ECDataAttachments.JEWEL_HANDLER)).tick();
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        ISpellTickManager manager = SpellTickHelper.get((Entity)player);
        if (manager != null) {
            manager.tick();
        }
    }
}

