/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import sirttas.elementalcraft.advancements.LookAtSourcePayload;
import sirttas.elementalcraft.data.attachment.ECDataAttachments;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.renderer.ISpellInstanceRenderer;
import sirttas.elementalcraft.spell.renderer.ISpellRenderer;
import sirttas.elementalcraft.spell.renderer.SpellRenderers;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;
import sirttas.elementalcraft.tag.ECTags;

@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class EntityClientHandler {
    private EntityClientHandler() {
    }

    @SubscribeEvent
    public static void renderSpellEffects(RenderLivingEvent.Post<?, ?> event) {
        PoseStack poseStack = event.getPoseStack();
        LivingEntity entity = event.getEntity();
        Holder<Spell> spell = SpellHelper.getSpellInUse((Entity)entity);
        float partialTicks = event.getPartialTick();
        MultiBufferSource buffer = event.getMultiBufferSource();
        int packedLight = event.getPackedLight();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - Mth.rotLerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot)));
        EntityClientHandler.renderSingleSpellFirstPerson((Spell)spell.value(), null, entity, partialTicks, poseStack, buffer, packedLight);
        SpellTickHelper.getSpellInstances((Entity)entity).forEach(i -> EntityClientHandler.renderSingleSpellFirstPerson(i.getSpell(), i, entity, partialTicks, poseStack, buffer, packedLight));
        poseStack.popPose();
    }

    /*
     * Unable to fully structure code
     */
    private static void renderSingleSpellFirstPerson(Spell spell, @Nullable AbstractSpellInstance instance, LivingEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!spell.isValid()) {
            return;
        }
        renderer = SpellRenderers.get(spell);
        if (renderer == null) {
            return;
        }
        poseStack.pushPose();
        if (!(renderer instanceof ISpellInstanceRenderer)) ** GOTO lbl-1000
        spellInstanceRenderer = (ISpellInstanceRenderer)renderer;
        if (instance != null) {
            spellInstanceRenderer.render(instance, partialTicks, poseStack, buffer, packedLight);
        } else lbl-1000:
        // 2 sources

        {
            renderer.render(spell, (Entity)entity, partialTicks, poseStack, buffer, packedLight);
        }
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderSpellEffects(RenderHandEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ISpellRenderer inUseRenderer = SpellRenderers.get((Spell)SpellHelper.getSpellInUse((Entity)player).value());
        InteractionHand hand = event.getHand();
        if (inUseRenderer != null && inUseRenderer.hideHand(hand)) {
            event.setCanceled(true);
        }
        EntityClientHandler.renderSpellEffectFirstPerson((AbstractClientPlayer)player, event.getItemStack(), hand, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
    }

    private static void renderSpellEffectFirstPerson(AbstractClientPlayer player, ItemStack stack, InteractionHand hand, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        LocalPlayer localPlayer;
        if (player instanceof LocalPlayer && !(localPlayer = (LocalPlayer)player).isScoping()) {
            Holder<Spell> spell = SpellHelper.getSpell(stack);
            if (localPlayer.isUsingItem() && localPlayer.getUsedItemHand() == hand && !stack.isEmpty()) {
                EntityClientHandler.renderSingleSpellFirstPerson((Spell)spell.value(), null, localPlayer, hand, partialTicks, poseStack, buffer, packedLight);
            }
            if (hand == InteractionHand.MAIN_HAND) {
                SpellTickHelper.getSpellInstances((Entity)localPlayer).forEach(i -> EntityClientHandler.renderSingleSpellFirstPerson(i.getSpell(), i, localPlayer, hand, partialTicks, poseStack, buffer, packedLight));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void renderSingleSpellFirstPerson(Spell spell, @Nullable AbstractSpellInstance instance, LocalPlayer localPlayer, InteractionHand hand, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!spell.isValid()) {
            return;
        }
        renderer = SpellRenderers.get(spell);
        if (renderer == null) {
            return;
        }
        poseStack.pushPose();
        if (!(renderer instanceof ISpellInstanceRenderer)) ** GOTO lbl-1000
        spellInstanceRenderer = (ISpellInstanceRenderer)renderer;
        if (instance != null) {
            spellInstanceRenderer.renderFirstPerson(instance, localPlayer, partialTicks, poseStack, buffer, packedLight);
        } else lbl-1000:
        // 2 sources

        {
            renderer.renderFirstPerson(spell, localPlayer, hand, partialTicks, poseStack, buffer, packedLight);
        }
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void onClientPostTick(ClientTickEvent.Post event) {
        BlockState state;
        BlockHitResult hitResult;
        Minecraft minecraft = Minecraft.getInstance();
        HitResult hitResult2 = minecraft.hitResult;
        if (hitResult2 instanceof BlockHitResult && (hitResult = (BlockHitResult)hitResult2).getType() == HitResult.Type.BLOCK && minecraft.level != null && minecraft.player != null && !((Boolean)minecraft.player.getData(ECDataAttachments.HAS_SEEN_SOURCE)).booleanValue() && (state = minecraft.level.getBlockState(hitResult.getBlockPos())).is(ECTags.Blocks.SOURCES)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new LookAtSourcePayload(hitResult), (CustomPacketPayload[])new CustomPacketPayload[0]);
            minecraft.player.setData(ECDataAttachments.HAS_SEEN_SOURCE, (Object)true);
        }
    }
}

