/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.element;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import sirttas.elementalcraft.api.element.ElementType;

public class ElementAmounts {
    public static final ElementAmounts EMPTY = new ElementAmounts(Map.of());
    public static final Codec<ElementAmounts> CODEC = Codec.unboundedMap(ElementType.CODEC, (Codec)Codec.INT).xmap(ElementAmounts::new, e -> e.amounts);
    public static final StreamCodec<RegistryFriendlyByteBuf, ElementAmounts> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(s -> new EnumMap(ElementType.class), ElementType.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT), e -> e.amounts, ElementAmounts::new);
    private final EnumMap<ElementType, Integer> amounts = new EnumMap(ElementType.class);

    private ElementAmounts(Map<ElementType, Integer> amounts) {
        this.amounts.putAll(amounts);
    }

    public int get(ElementType type) {
        return this.amounts.getOrDefault(type, 0);
    }

    public ElementAmounts with(ElementType type, int newCount) {
        EnumMap<ElementType, Integer> map = new EnumMap<ElementType, Integer>(this.amounts);
        map.put(type, newCount);
        return new ElementAmounts(map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.amounts, ((ElementAmounts)o).amounts);
    }

    public int hashCode() {
        return Objects.hashCode(this.amounts);
    }
}

