/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.shrine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.data.predicate.block.ECBlockPosPredicateTypes;
import sirttas.elementalcraft.data.predicate.block.shrine.IShrinePredicate;

public class HasShrineUpgradePredicate
implements IShrinePredicate {
    public static final String NAME = "has_shrine_upgrade";
    public static final MapCodec<HasShrineUpgradePredicate> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IDataManager.keyCodec(ElementalCraft.SHRINE_UPGRADE_MANAGER_KEY).fieldOf("shrine_upgrade").forGetter(p -> p.key), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(p -> p.count)).apply((Applicative)builder, HasShrineUpgradePredicate::new));
    private final int count;
    private final ResourceKey<ShrineUpgrade> key;

    public HasShrineUpgradePredicate(ResourceLocation upgradeId) {
        this(upgradeId, 1);
    }

    public HasShrineUpgradePredicate(ResourceLocation upgradeId, int count) {
        this((ResourceKey<ShrineUpgrade>)IDataManager.createKey(ElementalCraft.SHRINE_UPGRADE_MANAGER_KEY, (ResourceLocation)upgradeId), count);
    }

    public HasShrineUpgradePredicate(ResourceKey<ShrineUpgrade> key) {
        this(key, 1);
    }

    public HasShrineUpgradePredicate(ResourceKey<ShrineUpgrade> key, int count) {
        this.key = key;
        this.count = count;
    }

    @Override
    public boolean test(AbstractShrineBlockEntity shrine) {
        return shrine.getUpgradeCount(this.key) >= this.count;
    }

    public BlockPosPredicateType<HasShrineUpgradePredicate> getType() {
        return (BlockPosPredicateType)ECBlockPosPredicateTypes.HAS_SHRINE_UPGRADE.get();
    }

    @Nonnull
    public List<Component> getTooltip() {
        ResourceLocation loc = this.key.location();
        return List.of(Component.translatable((String)"tooltip.elementalcraft.predicate.shrine_upgrade", (Object[])new Object[]{this.count, Component.translatable((String)("block." + loc.getNamespace() + "." + loc.getPath()))}));
    }
}

