/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.rune;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.data.predicate.block.ECBlockPosPredicateTypes;
import sirttas.elementalcraft.data.predicate.block.rune.IRunePredicate;

public class HasRunePredicate
implements IRunePredicate {
    public static final String NAME = "has_rune";
    public static final MapCodec<HasRunePredicate> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IDataManager.keyCodec(ElementalCraftApi.RUNE_MANAGER_KEY).fieldOf("rune").forGetter(p -> p.key), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(p -> p.count)).apply((Applicative)builder, HasRunePredicate::new));
    private final int count;
    private final ResourceKey<Rune> key;

    public HasRunePredicate(ResourceLocation runeId) {
        this(runeId, 1);
    }

    public HasRunePredicate(ResourceLocation runeId, int count) {
        this((ResourceKey<Rune>)IDataManager.createKey(ElementalCraftApi.RUNE_MANAGER_KEY, (ResourceLocation)runeId), count);
    }

    public HasRunePredicate(ResourceKey<Rune> key) {
        this(key, 1);
    }

    public HasRunePredicate(ResourceKey<Rune> key, int count) {
        this.key = key;
        this.count = count;
    }

    @Override
    public boolean test(IRuneHandler handler) {
        return handler.getRuneCount(this.key) >= this.count;
    }

    public BlockPosPredicateType<HasRunePredicate> getType() {
        return (BlockPosPredicateType)ECBlockPosPredicateTypes.HAS_RUNE.get();
    }

    @Nonnull
    public List<Component> getTooltip() {
        ResourceLocation loc = this.key.location();
        return List.of(Component.translatable((String)"tooltip.elementalcraft.predicate.rune", (Object[])new Object[]{this.count, Component.translatable((String)("elementalcraft_rune." + loc.getNamespace() + "." + loc.getPath()))}));
    }
}

