/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block.pipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.data.predicate.block.ECBlockPosPredicateTypes;
import sirttas.elementalcraft.data.predicate.block.pipe.IPipePredicate;

public record HasPipeUpgrade(PipeUpgradeType<?> type) implements IPipePredicate
{
    public static final String NAME = "has_pipe_upgrade";
    public static final MapCodec<HasPipeUpgrade> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)PipeUpgradeTypes.REGISTRY.byNameCodec().fieldOf("pipe_upgrade").forGetter(HasPipeUpgrade::type)).apply((Applicative)builder, HasPipeUpgrade::new));

    @Override
    public boolean test(@Nonnull ElementPipeBlockEntity pipe, @Nullable Direction direction) {
        if (direction == null) {
            return pipe.getUpgrades().values().stream().anyMatch(this::test);
        }
        return this.test(pipe.getUpgrade(direction));
    }

    private boolean test(PipeUpgrade upgrade) {
        return upgrade != null && upgrade.getType() == this.type;
    }

    public BlockPosPredicateType<? extends IBlockPosPredicate> getType() {
        return (BlockPosPredicateType)ECBlockPosPredicateTypes.HAS_PIPE_UPGRADE.get();
    }

    @Nonnull
    public List<Component> getTooltip() {
        return List.of(Component.translatable((String)"tooltip.elementalcraft.predicate.pipe_upgrade", (Object[])new Object[]{this.type.asItem().getDescription()}));
    }
}

