/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.predicate.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.elementalcraft.data.predicate.block.ECBlockPosPredicateTypes;

public class RangeFromSpawnPredicate
implements IBlockPosPredicate {
    public static final String NAME = "range_from_spawn";
    public static final MapCodec<RangeFromSpawnPredicate> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("range").forGetter(p -> p.range)).apply((Applicative)builder, RangeFromSpawnPredicate::new));
    private final int range;
    private final int rangeSq;

    public RangeFromSpawnPredicate(int range) {
        this.range = range;
        this.rangeSq = range * range;
    }

    public BlockPosPredicateType<RangeFromSpawnPredicate> getType() {
        return (BlockPosPredicateType)ECBlockPosPredicateTypes.RANGE_FROM_SPAWN.get();
    }

    public boolean test(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction) {
        BlockPos blockPos;
        if (level instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)level;
            blockPos = accessor.getLevel().getSharedSpawnPos();
        } else {
            blockPos = BlockPos.ZERO;
        }
        BlockPos spawn = blockPos;
        return new BlockPos(spawn.getX(), 0, spawn.getZ()).distSqr((Vec3i)new BlockPos(pos.getX(), 0, pos.getZ())) > (double)this.rangeSq;
    }
}

