/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.data.attachment;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.jewel.handler.JewelHandler;
import sirttas.elementalcraft.spell.tick.SpellTickManager;

public class ECDataAttachments {
    private static final DeferredRegister<AttachmentType<?>> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"elementalcraft");
    public static final Supplier<AttachmentType<SpellTickManager>> SPELL_TICK_MANAGER = DEFERRED_REGISTER.register("spell_tick_manager", () -> AttachmentType.serializable(SpellTickManager::new).build());
    public static final Supplier<AttachmentType<JewelHandler>> JEWEL_HANDLER = DEFERRED_REGISTER.register("jewel_handler", () -> AttachmentType.builder(h -> {
        if (h instanceof Entity) {
            Entity entity = (Entity)h;
            return new JewelHandler(entity);
        }
        throw new IllegalArgumentException("JewelHandler can only be attached to an entity.");
    }).build());
    public static final Supplier<AttachmentType<Boolean>> HAS_SEEN_SOURCE = DEFERRED_REGISTER.register("has_seen_source", () -> AttachmentType.builder(() -> false).serialize((IAttachmentSerializer)new IAttachmentSerializer<ByteTag, Boolean>(){

        @NotNull
        public ByteTag write(@NotNull Boolean attachment, @NotNull HolderLookup.Provider provider) {
            return Boolean.TRUE.equals(attachment) ? ByteTag.ONE : ByteTag.ZERO;
        }

        @NotNull
        public Boolean read(@NotNull IAttachmentHolder holder, @NotNull ByteTag tag, @NotNull HolderLookup.Provider provider) {
            return tag.getAsByte() > 0;
        }
    }).build());

    private ECDataAttachments() {
    }

    public static void register(IEventBus modBus) {
        DEFERRED_REGISTER.register(modBus);
    }
}

