/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.container;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.container.AbstractSynchronizableContainer;

public class SingleStackContainer
extends AbstractSynchronizableContainer
implements INBTSerializable<CompoundTag> {
    protected ItemStack stack = ItemStack.EMPTY;

    public SingleStackContainer() {
        this(null);
    }

    public SingleStackContainer(Runnable syncCallback) {
        super(syncCallback);
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
        this.setChanged();
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Nonnull
    public ItemStack getItem(int index) {
        return index == 0 ? this.stack : ItemStack.EMPTY;
    }

    public void setItem(int index, @Nonnull ItemStack stack) {
        if (index == 0) {
            this.stack = stack;
        }
        this.setChanged();
    }

    public boolean canPlaceItem(int index, @Nonnull ItemStack stack) {
        return index == 0;
    }

    @Nonnull
    public ItemStack removeItem(int slot, int count) {
        ItemStack value = ContainerHelper.removeItem((List)Lists.newArrayList((Object[])new ItemStack[]{this.stack}), (int)slot, (int)count);
        this.setChanged();
        return value;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack ret = this.stack;
        this.stack = ItemStack.EMPTY;
        return ret;
    }

    @Nonnull
    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        if (!this.stack.isEmpty()) {
            compoundTag.put("stack", this.stack.save(provider));
        }
        return compoundTag;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @NotNull CompoundTag compoundTag) {
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundTag.getCompound("stack"));
    }
}

