/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.container;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.container.AbstractSynchronizableContainer;

public class IOContainer
extends AbstractSynchronizableContainer
implements WorldlyContainer,
INBTSerializable<CompoundTag> {
    private ItemStack input = ItemStack.EMPTY;
    private ItemStack output = ItemStack.EMPTY;

    public IOContainer() {
        this(null);
    }

    public IOContainer(Runnable syncCallback) {
        super(syncCallback);
    }

    public void clearContent() {
        this.input = ItemStack.EMPTY;
        this.output = ItemStack.EMPTY;
    }

    public int getContainerSize() {
        return 2;
    }

    public boolean isEmpty() {
        return this.input.isEmpty() && this.output.isEmpty();
    }

    @Nonnull
    public ItemStack getItem(int index) {
        if (index == 0) {
            return this.input;
        }
        if (index == 1) {
            return this.output;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int index, @Nonnull ItemStack stack) {
        if (index == 0) {
            this.input = stack;
        } else if (index == 1) {
            this.output = stack;
        }
        this.setChanged();
    }

    public boolean canPlaceItem(int index, @Nonnull ItemStack stack) {
        return index == 0;
    }

    @Nonnull
    public ItemStack removeItem(int index, int count) {
        ItemStack value = ContainerHelper.removeItem((List)Lists.newArrayList((Object[])new ItemStack[]{this.input, this.output}), (int)index, (int)count);
        this.setChanged();
        return value;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack ret = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        return ret;
    }

    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (!this.input.isEmpty()) {
            tag.put("input", this.input.save(provider));
        }
        if (!this.output.isEmpty()) {
            tag.put("output", this.output.save(provider));
        }
        return tag;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        this.input = tag.contains("input") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("input")) : ItemStack.EMPTY;
        this.output = tag.contains("output") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("output")) : ItemStack.EMPTY;
    }

    @Nonnull
    public int[] getSlotsForFace(@Nonnull Direction side) {
        return new int[]{0, 1};
    }

    public boolean canPlaceItemThroughFace(int index, @Nonnull ItemStack stack, Direction direction) {
        return index == 0 || direction == null;
    }

    public boolean canTakeItemThroughFace(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return index == 1 || direction == null;
    }
}

