/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.container;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;

public class ECContainerHelper {
    private ECContainerHelper() {
    }

    public static IItemHandler getItemHandlerAt(@Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return ECContainerHelper.getItemHandlerAt(world, pos, null);
    }

    public static IItemHandler getItemHandlerAt(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable Direction side) {
        Level l;
        IItemHandler handler;
        if (level instanceof Level && (handler = (IItemHandler)(l = (Level)level).getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side)) != null) {
            return handler;
        }
        return BlockEntityHelper.getBlockEntity(level, pos).map(t -> ECContainerHelper.getItemHandler(t, side)).orElse(EmptyItemHandler.INSTANCE);
    }

    @Nonnull
    public static IItemHandler getItemHandler(BlockEntity entity, @Nullable Direction side) {
        IItemHandler handler = (IItemHandler)BlockEntityHelper.getCapability(Capabilities.ItemHandler.BLOCK, entity, side);
        if (handler != null) {
            return handler;
        }
        if (entity instanceof WorldlyContainer) {
            WorldlyContainer worldlyContainer = (WorldlyContainer)entity;
            if (side != null) {
                return new SidedInvWrapper(worldlyContainer, side);
            }
        }
        if (entity instanceof Container) {
            Container container = (Container)entity;
            return new InvWrapper(container);
        }
        return EmptyItemHandler.INSTANCE;
    }

    public static int getSlotFor(Container inv, ItemStack stack) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack current = inv.getItem(i);
            if (current.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)current)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEmpty(IItemHandler targetInv) {
        for (int i = 0; i < targetInv.getSlots(); ++i) {
            if (targetInv.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

