/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ECConfig {
    public static final Server SERVER;
    public static final ModConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;

    private ECConfig() {
    }

    static {
        Pair serverPair = new ModConfigSpec.Builder().configure(Server::new);
        Pair clientPair = new ModConfigSpec.Builder().configure(Client::new);
        SERVER_SPEC = (ModConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static class Server {
        public final ModConfigSpec.IntValue rudimentaryExtractorExtractionAmount;
        public final ModConfigSpec.IntValue rudimentaryExtractorMaxRunes;
        public final ModConfigSpec.IntValue extractorExtractionAmount;
        public final ModConfigSpec.IntValue extractorMaxRunes;
        public final ModConfigSpec.IntValue improvedExtractorExtractionAmount;
        public final ModConfigSpec.IntValue improvedExtractorMaxRunes;
        public final ModConfigSpec.IntValue diffuserDiffusionAmount;
        public final ModConfigSpec.IntValue diffuserMaxRunes;
        public final ModConfigSpec.IntValue fireFurnaceElementAmount;
        public final ModConfigSpec.IntValue fireBlastFurnaceElementAmount;
        public final ModConfigSpec.BooleanValue binderRecipeMatchOrder;
        public final ModConfigSpec.IntValue enchantmentLiquefierElementAmount;
        public final ModConfigSpec.DoubleValue enchantmentLiquefierBreakChance;
        public final ModConfigSpec.BooleanValue pureOreRecipeInjection;
        public final ModConfigSpec.IntValue rudimentaryPipeTransferAmount;
        public final ModConfigSpec.IntValue pipeTransferAmount;
        public final ModConfigSpec.IntValue improvedPipeTransferAmount;
        public final ModConfigSpec.BooleanValue pipePathCache;
        public final ModConfigSpec.IntValue elementBeamRange;
        public final ModConfigSpec.DoubleValue elementPumpMultiplier;
        public final ModConfigSpec.DoubleValue elementPumpWaste;
        public final ModConfigSpec.IntValue elementPumpMaxRunes;
        public final ModConfigSpec.IntValue sorterCooldown;
        public final ModConfigSpec.IntValue sorterMaxItem;
        public final ModConfigSpec.IntValue sorterMaxRunes;
        public final ModConfigSpec.IntValue pedestalCapacity;
        public final ModConfigSpec.IntValue pedestalMaxRunes;
        public final ModConfigSpec.IntValue sourceBreedingBaseCost;
        public final ModConfigSpec.IntValue sourceBreederPedestalCapacity;
        public final ModConfigSpec.IntValue sourceBreederPedestalMaxRunes;
        public final ModConfigSpec.IntValue fortuneShrineUpgradeLevel;
        public final ModConfigSpec.IntValue greaterFortuneShrineUpgradeLevel;
        public final ModConfigSpec.IntValue elementHolderCapacity;
        public final ModConfigSpec.IntValue elementHolderTransferAmount;
        public final ModConfigSpec.IntValue pureElementHolderCapacity;
        public final ModConfigSpec.IntValue pureElementHolderTransferAmount;
        public final ModConfigSpec.IntValue focusMaxSpell;
        public final ModConfigSpec.IntValue spellBookMaxSpell;
        public final ModConfigSpec.IntValue shardElementAmount;
        public final ModConfigSpec.BooleanValue spellConsumeOnFail;
        public final ModConfigSpec.IntValue mekanismPureOreInputMultiplier;
        public final ModConfigSpec.IntValue mekanismPureOreOutputMultiplier;

        public Server(ModConfigSpec.Builder builder) {
            builder.comment("ElementalCraft config").comment("Note: ElementalCraft favor setting config for blocks and stacks through custom datatypes found inside data/elementalcraft/elementalcraft/ (https://github.com/Sirttas/ElementalCraft/tree/1.21/src/generated/resources/data/elementalcraft/elementalcraft)").push("elementalcraft");
            builder.push("extractor");
            this.rudimentaryExtractorExtractionAmount = builder.comment("The amount of element extracted by a rudimentary extractor.").defineInRange("rudimentaryExtractorExtractionAmount", 5, 0, 100);
            this.rudimentaryExtractorMaxRunes = builder.comment("The max amount of runes on a rudimentary extractor.").defineInRange("rudimentaryExtractorMaxRunes", 1, 0, 10);
            this.extractorExtractionAmount = builder.comment("The amount of element extracted by an extractor.").defineInRange("extractorExtractionAmount", 25, 0, 100);
            this.extractorMaxRunes = builder.comment("The max amount of runes on an extractor.").defineInRange("extractorMaxRunes", 2, 0, 10);
            this.improvedExtractorExtractionAmount = builder.comment("The amount of element extracted by an improved extractor.").defineInRange("improvedExtractorExtractionAmount", 100, 0, 500);
            this.improvedExtractorMaxRunes = builder.comment("The max amount of runes on an improved extractor.").defineInRange("improvedExtractoMaxRunes", 3, 0, 10);
            builder.pop().push("diffuser");
            this.diffuserDiffusionAmount = builder.comment("The amount of element transfered by a diffuser.").defineInRange("diffuserDiffusionAmount", 5, 0, 100);
            this.diffuserMaxRunes = builder.comment("The max amount of runes on a diffuser.").defineInRange("diffuserMaxRunes", 3, 0, 10);
            builder.pop().push("fireFurnace");
            this.fireFurnaceElementAmount = builder.comment("The amount multiplied by the cooking time of the furnace recipe.").defineInRange("fireFurnaceElementAmount", 5, 0, 1000);
            builder.push("fireBlastFurnace");
            this.fireBlastFurnaceElementAmount = builder.comment("The amount multiplied by the cooking time of the blast furnace recipe.").defineInRange("fireBlastFurnaceElementAmount", 10, 0, 1000);
            builder.pop().push("binder");
            this.binderRecipeMatchOrder = builder.comment("Define if or not binder recipe require to be ordered.").define("binderRecipeMatchOrder", true);
            builder.pop().push("enchantmentLiquefier");
            this.enchantmentLiquefierElementAmount = builder.comment("The cost of liquefying echantments.").defineInRange("enchantmentLiquefierElementAmount", 5000, 0, 100000000);
            this.enchantmentLiquefierBreakChance = builder.comment("The chance of breaking echantments.").defineInRange("enchantmentLiquefierBreakChance", 2.5, 0.0, 100.0);
            builder.pop().push("purifier").push("pureOre");
            this.pureOreRecipeInjection = builder.comment("Set to false if you want to manually manage processing of pure ore.").define("pureOreRecipeInjection", true);
            builder.pop(2).push("elementPipe");
            this.rudimentaryPipeTransferAmount = builder.comment("The amount of element transferred by rudimentary pipes.").defineInRange("rudimentaryPipeTransferAmount", 25, 0, 10000);
            this.pipeTransferAmount = builder.comment("The amount of element transferred by pipes.").defineInRange("pipeTransferAmount", 100, 0, 10000);
            this.improvedPipeTransferAmount = builder.comment("The amount of element transferred by improved pipes.").defineInRange("improvedPipeTransferAmount", 500, 0, 10000);
            this.pipePathCache = builder.comment("Cache the last path used by the pipe to increase performances.").define("pipePathCache", true);
            builder.push("upgrade").push("elementBeam");
            this.elementBeamRange = builder.comment("The ranges of the element beam.").defineInRange("elementBeamRange", 10, 0, 100);
            builder.pop().push("elementPump");
            this.elementPumpMultiplier = builder.comment("The amount of element pumped by the element pump.").defineInRange("elementPumpMultiplier", 5.0, 0.0, 100.0);
            this.elementPumpWaste = builder.comment("The amount of element wasted by the element pump.").defineInRange("elementPumpWaste", 0.1, 0.0, 1.0);
            this.elementPumpMaxRunes = builder.comment("The max amount of runes an element pump can have.").defineInRange("elementPumpMaxRunes", 3, 0, 10);
            builder.pop(3).push("sorter");
            this.sorterCooldown = builder.comment("The amount of tick between two ordered sorter item transfer.").defineInRange("sorterCooldown", 10, 0, 100);
            this.sorterMaxItem = builder.comment("The max amount of stacks an order sorter can filter.").defineInRange("sorterMaxItem", 15, 0, 100);
            this.sorterMaxRunes = builder.comment("The max amount of runes an order sorter can have.").defineInRange("sorterMaxRunes", 3, 0, 10);
            builder.pop(2).comment("Pure Infuser and pedestals config").push("pureInfuser").push("pedestals");
            this.pedestalMaxRunes = builder.comment("The max amount of runes on a pedestal.").defineInRange("pedestalMaxRunes", 1, 0, 10);
            this.pedestalCapacity = builder.comment("The element capacity of a pedestal.").defineInRange("pedestalCapacity", 10000, 0, 100000000);
            builder.pop(2).comment("Shrines config").push("shrines").comment("Shrine upgrades config").push("upgrades");
            this.fortuneShrineUpgradeLevel = builder.comment("The fortune level of the fortune shrine upgrade.").defineInRange("fortuneShrineUpgradeLevel", 1, 1, 10);
            this.greaterFortuneShrineUpgradeLevel = builder.comment("The fortune level of the fortune shrine upgrade.").defineInRange("greaterFortuneShrineUpgradeLevel", 3, 1, 10);
            builder.pop(2).comment("Items config").push("stacks").push("elementHolder");
            this.elementHolderCapacity = builder.comment("The element capacity of an element holder.").defineInRange("elementHolderCapacity", 10000, 0, 100000000);
            this.elementHolderTransferAmount = builder.comment("The amount of element transferred by an element holder.").defineInRange("elementHolderTransferAmount", 25, 0, 1000);
            builder.push("pure");
            this.pureElementHolderCapacity = builder.comment("The element capacity of a pure element holder.").defineInRange("pureElementHolderCapacity", 100000, 0, 100000000);
            this.pureElementHolderTransferAmount = builder.comment("The amount of element transferred by a pure element holder.").defineInRange("pureElementHolderTransferAmount", 100, 0, 1000);
            builder.pop(2);
            this.focusMaxSpell = builder.comment("The max number of spells on a focus.").defineInRange("focusMaxSpell", 10, 1, 20);
            this.spellBookMaxSpell = builder.comment("The max number of spells on an elementalist grimoire.").defineInRange("spellBookMaxSpell", 100, 1, 1000);
            this.shardElementAmount = builder.comment("The amount of element contained in a single shard.").defineInRange("shardElementAmount", 250, 0, 1000);
            builder.pop().comment("Spell config").push("spell");
            this.spellConsumeOnFail = builder.comment("Define if a spell will be cast (and destroyed) or not if you dont have enought element.").define("spellConsumeOnFail", false);
            builder.pop().comment("Source config").push("source").comment("Source Breeder and pedestals config").push("breeder");
            this.sourceBreedingBaseCost = builder.comment("The base cost of breeding sources.").defineInRange("sourceBreedingBaseCost", 100000, 0, 100000000);
            builder.push("pedestals");
            this.sourceBreederPedestalMaxRunes = builder.comment("The max amount of runes on a source breeder pedestal.").defineInRange("sourceBreederPedestalMaxRunes", 1, 0, 10);
            this.sourceBreederPedestalCapacity = builder.comment("The element capacity of a source breeder pedestal.").defineInRange("sourceBreederPedestalCapacity", 100000, 0, 100000000);
            builder.pop(3).comment("mod interaction config").push("interaction").push("mekanism");
            this.mekanismPureOreInputMultiplier = builder.comment("The amount multiplier when using pure ore in mekanism.").defineInRange("mekanismPureOreInputMultiplier", 5, 0, 20);
            this.mekanismPureOreOutputMultiplier = builder.comment("The amount multiplier when using pure ore in mekanism.").defineInRange("mekanismPureOreOutputMultiplier", 3, 0, 20);
            builder.pop(2);
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue usePaleElementGauge;
        public final ModConfigSpec.IntValue rangeDisplayDuration;
        public final ModConfigSpec.BooleanValue renderPedestalShadow;
        public final ModConfigSpec.BooleanValue renderShrineUpgradeShadow;
        public final ModConfigSpec.BooleanValue renderInstrumentShadow;
        public final ModConfigSpec.IntValue gaugeOffsetX;
        public final ModConfigSpec.IntValue gaugeOffsetY;

        public Client(ModConfigSpec.Builder builder) {
            builder.comment("ElementalCraft client config").push("elementalcraft-client");
            this.rangeDisplayDuration = builder.comment("The duration of block ranges display.").defineInRange("rangeDisplayDuration", 600, 0, 10000);
            builder.push("shadowBlocks");
            this.renderPedestalShadow = builder.comment("Display a shadow where pedestals can be placed.").define("renderPedestalShadow", true);
            this.renderShrineUpgradeShadow = builder.comment("Display a shadow where shrine upgrades can be placed.").define("renderShrineUpgradeShadow", true);
            this.renderInstrumentShadow = builder.comment("Display a shadow where instruments can be placed.").define("renderInstrumentShadow", true);
            builder.pop().push("gauge");
            this.usePaleElementGauge = builder.comment("Use pale element gauges.").define("usePaleElementGauge", false);
            this.gaugeOffsetX = builder.comment("the offset of the gauge on the X axis.").defineInRange("gaugeOffsetX", 0, -10000, 10000);
            this.gaugeOffsetY = builder.comment("the offset of the gauge on the Y axis.").defineInRange("gaugeOffsetY", 0, -10000, 10000);
            builder.pop();
        }
    }
}

