/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.component;

import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.source.trait.holder.ItemSourceTraitHolder;
import sirttas.elementalcraft.element.ElementAmounts;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellList;
import sirttas.elementalcraft.spell.Spells;

public class ECDataComponents {
    private static final DeferredRegister<DataComponentType<?>> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"elementalcraft");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlockPos>> TARGET_POS = ECDataComponents.register("target_pos", b -> b.persistent(BlockPos.CODEC).networkSynchronized(BlockPos.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Holder<ToolInfusion>>> TOOL_INFUSION = ElementalCraftApi.TOOL_INFUSION_MANAGER.registerComponentType(DEFERRED_REGISTER);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Holder<Rune>>> RUNE = ElementalCraftApi.RUNE_MANAGER.registerComponentType(DEFERRED_REGISTER);
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ElementType>> ELEMENT_TYPE = ECDataComponents.register("element_type", b -> b.persistent(ElementType.CODEC).networkSynchronized(ElementType.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> ELEMENT_AMOUNT = ECDataComponents.register("element_amount", b -> b.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ElementAmounts>> ELEMENT_AMOUNTS = ECDataComponents.register("element_amounts", b -> b.persistent(ElementAmounts.CODEC).networkSynchronized(ElementAmounts.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CustomData>> PIPE_UPGRADE_DATA = ECDataComponents.register("pipe_upgrade_data", b -> b.persistent(CustomData.CODEC_WITH_ID).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ResourceLocation>> PURE_ORE = ECDataComponents.register("pure_ore", b -> b.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Jewel>> JEWEL = ECDataComponents.register("jewel", b -> b.persistent(Jewels.REGISTRY.byNameCodec()).networkSynchronized(ByteBufCodecs.registry(Jewels.REGISTRY_KEY)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Holder<Spell>>> SPELL = ECDataComponents.register("spell", b -> b.persistent(Spells.REGISTRY.holderByNameCodec()).networkSynchronized(ByteBufCodecs.holderRegistry(Spells.REGISTRY_KEY)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SpellList>> SPELL_LIST = ECDataComponents.register("spell_list", b -> b.persistent(SpellList.CODEC).networkSynchronized(SpellList.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ItemSourceTraitHolder>> SOURCE_TRAITS_HOLDER = ECDataComponents.register("source_traits_holder", b -> b.persistent(ItemSourceTraitHolder.CODEC).networkSynchronized(ItemSourceTraitHolder.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> AIR_MILL_DAMAGE = ECDataComponents.register("air_mill_damage", b -> b.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));

    private ECDataComponents() {
    }

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> factory) {
        return DEFERRED_REGISTER.register(name, () -> ((DataComponentType.Builder)factory.apply(DataComponentType.builder())).build());
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

