/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.client.model;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.apache.commons.lang3.StringUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.diffuser.DiffuserRenderer;
import sirttas.elementalcraft.block.instrument.io.mill.MillRenderer;
import sirttas.elementalcraft.block.pipe.ElementPipeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgradeModelShaper;
import sirttas.elementalcraft.block.pipe.upgrade.beam.ElementBeamPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.pump.ElementPumpPipeUpgradeRenderer;
import sirttas.elementalcraft.block.pipe.upgrade.valve.ElementValvePipeUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.AccelerationShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.translocation.TranslocationShrineUpgradeRenderer;
import sirttas.elementalcraft.block.shrine.upgrade.vortex.VortexShrineUpgradeRenderer;
import sirttas.elementalcraft.block.source.SourceRenderer;
import sirttas.elementalcraft.block.synthesizer.cracking.CrackingSynthesizerRenderer;
import sirttas.elementalcraft.block.synthesizer.mill.AirMillSynthesizerRenderer;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerRenderer;
import sirttas.elementalcraft.client.model.AbstractECModelShaper;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.client.model.ECModelShapers;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class ECModelHandler {
    private ECModelHandler() {
    }

    @SubscribeEvent
    public static void initShapers(RenderLevelStageEvent.RegisterStageEvent event) {
        ECModelShapers.register(PipeUpgradeModelShaper.NAME, PipeUpgradeModelShaper::new);
        ECModelShapers.init(Minecraft.getInstance().getModelManager());
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        Consumer<ResourceLocation> addModel = ECModelHandler.addModel(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        ECModelHandler.registerRuneModels(addModel);
        ECModelShapers.getAll().forEach(shaper -> shaper.registerModels(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0)));
        event.register(ElementPipeRenderer.SIDE_LOCATION);
        event.register(ElementPipeRenderer.EXTRACT_LOCATION);
        event.register(CrackingSynthesizerRenderer.HEAD_LOCATION);
        event.register(SolarSynthesizerRenderer.LENS_LOCATION);
        event.register(MillRenderer.WATER_MILL_GRINDSTONE_SHAFT_LOCATION);
        event.register(MillRenderer.AIR_MILL_GRINDSTONE_SHAFT_LOCATION);
        event.register(MillRenderer.WATER_MILL_WOOD_SAW_SHAFT_LOCATION);
        event.register(MillRenderer.AIR_MILL_WOOD_SAW_SHAFT_LOCATION);
        event.register(AirMillSynthesizerRenderer.SHAFT_LOCATION);
        event.register(DiffuserRenderer.CUBE_LOCATION);
        event.register(AccelerationShrineUpgradeRenderer.CLOCK_LOCATION);
        event.register(VortexShrineUpgradeRenderer.RING_LOCATION);
        event.register(TranslocationShrineUpgradeRenderer.RING_LOCATION);
        event.register(SourceRenderer.STABILIZER_LOCATION);
        event.register(ElementValvePipeUpgradeRenderer.OPEN_LOCATION);
        event.register(ElementValvePipeUpgradeRenderer.CLOSE_LOCATION);
        event.register(ElementBeamPipeUpgradeRenderer.RING_1_LOCATION);
        event.register(ElementBeamPipeUpgradeRenderer.RING_2_LOCATION);
        event.register(ElementBeamPipeUpgradeRenderer.RING_3_LOCATION);
        event.register(ElementPumpPipeUpgradeRenderer.PUMP_LOCATION);
        event.register(ECModelHelper.standalone("item/air_mill_synthesizer_broken"));
        event.register(ECModelHelper.standalone("item/air_mill_grindstone_broken"));
        event.register(ECModelHelper.standalone("item/air_mill_wood_saw_broken"));
    }

    private static void registerRuneModels(Consumer<ResourceLocation> addModel) {
        ElementalCraftApi.RUNE_MANAGER.getData().values().forEach(rune -> addModel.accept(rune.getModelName()));
        Minecraft.getInstance().getResourceManager().listResources("models/" + ElementalCraftApi.RUNE_MANAGER.getFolder(), fileName -> fileName.getPath().endsWith(".json")).keySet().forEach(addModel);
    }

    private static Consumer<ResourceLocation> addModel(Consumer<ModelResourceLocation> consumer) {
        return m -> {
            String path = StringUtils.removeStart((String)StringUtils.removeEnd((String)m.getPath(), (String)".json"), (String)"models/");
            if (path.startsWith("item/")) {
                consumer.accept(ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)m.getNamespace(), (String)StringUtils.removeStart((String)path, (String)"item/"))));
            } else {
                consumer.accept(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)m.getNamespace(), (String)path)));
            }
        };
    }

    @SubscribeEvent
    public static void onBakingComplete(ModelEvent.BakingCompleted event) {
        ECModelShapers.getAll().forEach(AbstractECModelShaper::rebuildCache);
    }
}

