/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.client.model;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractECModelShaper<T> {
    private final Map<T, BakedModel> cache = new IdentityHashMap<T, BakedModel>();
    protected final ModelManager modelManager;

    protected AbstractECModelShaper(ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public BakedModel getBlockModel(T target) {
        BakedModel model = this.cache.get(target);
        if (model == null) {
            model = this.modelManager.getMissingModel();
        }
        return model;
    }

    public void rebuildCache() {
        this.cache.clear();
        this.cache.putAll(this.getModels());
    }

    protected abstract Map<? extends T, ? extends BakedModel> getModels();

    public abstract void registerModels(Consumer<ModelResourceLocation> var1);
}

