/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.capability;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.EmptyElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.crafting.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.capability.PipeUpgradeCapabilities;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.container.IContainerBlockEntity;
import sirttas.elementalcraft.container.IElementStorageBlocKEntity;
import sirttas.elementalcraft.container.IRuneableBlockEntity;
import sirttas.elementalcraft.data.attachment.ECDataAttachments;
import sirttas.elementalcraft.entity.player.PlayerElementStorage;
import sirttas.elementalcraft.entity.player.PlayerSpellTickManager;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.holder.AbstractElementHolderItem;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleItem;
import sirttas.elementalcraft.jewel.handler.ClientJewelHandler;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.spell.tick.ISpellTickManager;
import sirttas.elementalcraft.spell.tick.SpellTickManager;

@EventBusSubscriber(modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class ECCapabilityHandler {
    private ECCapabilityHandler() {
    }

    @SubscribeEvent
    public static void registerProviders(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(ElementalCraftCapabilities.ElementStorage.BLOCK, (BlockEntityType)ECBlockEntityTypes.SOURCE.get(), (blockEntity, v) -> blockEntity.getElementStorage());
        event.registerBlockEntity(ElementalCraftCapabilities.SourceTrait.BLOCK, (BlockEntityType)ECBlockEntityTypes.SOURCE.get(), (pedestal, v) -> pedestal.getTraitHolder());
        List.of(ECBlockEntityTypes.CONTAINER, ECBlockEntityTypes.RESERVOIR, ECBlockEntityTypes.CREATIVE_CONTAINER).forEach(t -> {
            event.registerBlockEntity(ElementContainer.CAPABILITY, (BlockEntityType)t.get(), (blockEntity, v) -> blockEntity);
            event.registerBlockEntity(ElementalCraftCapabilities.ElementStorage.BLOCK, (BlockEntityType)t.get(), (blockEntity, v) -> blockEntity.getElementStorage());
        });
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.INFUSER);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.BINDER);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.BINDER_IMPROVED);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.CRYSTALLIZER);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.INSCRIBER);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.WATER_MILL_GRINDSTONE);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.AIR_MILL_GRINDSTONE);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.WATER_MILL_WOOD_SAW);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.AIR_MILL_WOOD_SAW);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.ENCHANTMENT_LIQUEFIER);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.PURE_INFUSER);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.FIRE_FURNACE);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.FIRE_BLAST_FURNACE);
        ECCapabilityHandler.registerCraftingBlockEntityCapabilities(event, ECBlockEntityTypes.PURIFIER);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ECBlockEntityTypes.SOURCE_BREEDER.get(), IContainerBlockEntity::getItemHandler);
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, (BlockEntityType)ECBlockEntityTypes.SOURCE_BREEDER.get(), (blockEntity, v) -> blockEntity.getRuneHandler());
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, (BlockEntityType)ECBlockEntityTypes.EXTRACTOR.get(), (blockEntity, v) -> blockEntity.getRuneHandler());
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, (BlockEntityType)ECBlockEntityTypes.DIFFUSER.get(), (blockEntity, v) -> blockEntity.getRuneHandler());
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, (BlockEntityType)ECBlockEntityTypes.SORTER.get(), (blockEntity, v) -> blockEntity.getRuneHandler());
        event.registerBlockEntity(ElementalCraftCapabilities.ElementTransferer.BLOCK, (BlockEntityType)ECBlockEntityTypes.PIPE.get(), (blockEntity, v) -> blockEntity.getTransferer());
        PipeUpgradeCapabilities.register(PipeUpgradeCapabilities.RUNE_HANDLER, (PipeUpgradeType)PipeUpgradeTypes.ELEMENT_PUMP.get(), (upgrade, v) -> upgrade.getRuneHandler());
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, (BlockEntityType)ECBlockEntityTypes.PIPE.get(), PipeUpgradeCapabilities.RUNE_HANDLER.getBlockCapabilityProvider());
        ECCapabilityHandler.registerElementRunesCapabilities(event, ECBlockEntityTypes.CRACKING_SYNTHESIZER);
        ECCapabilityHandler.registerIERCapabilities(event, ECBlockEntityTypes.COMBUSTION_SYNTHESIZER);
        ECCapabilityHandler.registerElementRunesCapabilities(event, ECBlockEntityTypes.DRAINING_SYNTHESIZER);
        ECCapabilityHandler.registerElementRunesCapabilities(event, ECBlockEntityTypes.VIBRATION_SYNTHESIZER);
        ECCapabilityHandler.registerIERCapabilities(event, ECBlockEntityTypes.SOLAR_SYNTHESIZER);
        ECCapabilityHandler.registerIERCapabilities(event, ECBlockEntityTypes.CULINARY_SYNTHESIZER);
        ECCapabilityHandler.registerElementRunesCapabilities(event, ECBlockEntityTypes.SCULK_CRACKING_SYNTHESIZER);
        ECCapabilityHandler.registerElementRunesCapabilities(event, ECBlockEntityTypes.AIR_MILL_SYNTHESIZER);
        ECCapabilityHandler.registerIERCapabilities(event, ECBlockEntityTypes.PEDESTAL);
        ECCapabilityHandler.registerSourceBreederPedestalCapabilities(event);
        List.of(ECBlockEntityTypes.FIRE_PYLON, ECBlockEntityTypes.VACUUM_SHRINE, ECBlockEntityTypes.GROWTH_SHRINE, ECBlockEntityTypes.HARVEST_SHRINE, ECBlockEntityTypes.LUMBER_SHRINE, ECBlockEntityTypes.LAVA_SHRINE, ECBlockEntityTypes.ORE_SHRINE, ECBlockEntityTypes.OVERLOAD_SHRINE, ECBlockEntityTypes.SWEET_SHRINE, ECBlockEntityTypes.ENDER_LOCK_SHRINE, ECBlockEntityTypes.BREEDING_SHRINE, ECBlockEntityTypes.GROVE_SHRINE, ECBlockEntityTypes.SPRING_SHRINE, ECBlockEntityTypes.BUDDING_SHRINE, ECBlockEntityTypes.SPAWNING_SHRINE).forEach(t -> event.registerBlockEntity(ElementalCraftCapabilities.ElementStorage.BLOCK, (BlockEntityType)t.get(), (blockEntity, v) -> blockEntity.getElementStorage()));
        event.registerBlockEntity(ElementalCraftCapabilities.ElementTransferer.BLOCK, (BlockEntityType)ECBlockEntityTypes.OVERCLOCKED_ACCELERATION_SHRINE_UPGRADE.get(), (blockEntity, v) -> blockEntity.getTransferer());
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, (BlockEntityType)ECBlockEntityTypes.GREATER_FORTUNE_SHRINE_UPGRADE.get(), (blockEntity, v) -> blockEntity.getRuneHandler());
        event.registerBlock(ElementalCraftCapabilities.ElementStorage.BLOCK_FOR_ELEMENT, (level, pos, state, blockEntity, context) -> {
            IElementStorage storage = (IElementStorage)level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, pos, state, blockEntity, (Object)(context != null ? context.direction() : null));
            if (storage != null) {
                return storage.forElement(context != null ? context.elementType() : ElementType.NONE);
            }
            return null;
        }, new Block[]{(Block)ECBlocks.FIRE_SOURCE.get(), (Block)ECBlocks.WATER_SOURCE.get(), (Block)ECBlocks.EARTH_SOURCE.get(), (Block)ECBlocks.AIR_SOURCE.get(), (Block)ECBlocks.CONTAINER.get(), (Block)ECBlocks.SMALL_CONTAINER.get(), (Block)ECBlocks.CREATIVE_CONTAINER.get(), (Block)ECBlocks.FIRE_RESERVOIR.get(), (Block)ECBlocks.WATER_RESERVOIR.get(), (Block)ECBlocks.EARTH_RESERVOIR.get(), (Block)ECBlocks.AIR_RESERVOIR.get(), (Block)ECBlocks.CRACKING_SYNTHESIZER.get(), (Block)ECBlocks.COMBUSTION_SYNTHESIZER.get(), (Block)ECBlocks.DRAINING_SYNTHESIZER.get(), (Block)ECBlocks.VIBRATION_SYNTHESIZER.get(), (Block)ECBlocks.SOLAR_SYNTHESIZER.get(), (Block)ECBlocks.FIRE_PEDESTAL.get(), (Block)ECBlocks.WATER_PEDESTAL.get(), (Block)ECBlocks.EARTH_PEDESTAL.get(), (Block)ECBlocks.AIR_PEDESTAL.get(), (Block)ECBlocks.SOURCE_BREEDER_PEDESTAL.get(), (Block)ECBlocks.FIRE_PYLON.get(), (Block)ECBlocks.VACUUM_SHRINE.get(), (Block)ECBlocks.GROWTH_SHRINE.get(), (Block)ECBlocks.HARVEST_SHRINE.get(), (Block)ECBlocks.LUMBER_SHRINE.get(), (Block)ECBlocks.MELTING_SHRINE.get(), (Block)ECBlocks.ORE_SHRINE.get(), (Block)ECBlocks.OVERLOAD_SHRINE.get(), (Block)ECBlocks.SWEET_SHRINE.get(), (Block)ECBlocks.ENDER_LOCK_SHRINE.get(), (Block)ECBlocks.BREEDING_SHRINE.get(), (Block)ECBlocks.GROVE_SHRINE.get(), (Block)ECBlocks.SPRING_SHRINE.get(), (Block)ECBlocks.BUDDING_SHRINE.get(), (Block)ECBlocks.SPAWNING_SHRINE.get()});
        ECCapabilityHandler.deferBlockCapabilityBellow(event, Capabilities.ItemHandler.BLOCK, new Supplier[]{ECBlocks.AIR_MILL_GRINDSTONE, ECBlocks.AIR_MILL_WOOD_SAW, ECBlocks.ENCHANTMENT_LIQUEFIER, ECBlocks.SOURCE_BREEDER});
        ECCapabilityHandler.deferBlockCapabilityBellow(event, ElementalCraftCapabilities.RuneHandler.BLOCK, new Supplier[]{ECBlocks.AIR_MILL_GRINDSTONE, ECBlocks.AIR_MILL_WOOD_SAW, ECBlocks.ENCHANTMENT_LIQUEFIER, ECBlocks.SOURCE_BREEDER, ECBlocks.AIR_MILL_SYNTHESIZER});
        ECCapabilityHandler.deferBlockCapabilityBellow(event, ElementalCraftCapabilities.ElementStorage.BLOCK, new Supplier[]{ECBlocks.FIRE_RESERVOIR, ECBlocks.WATER_RESERVOIR, ECBlocks.EARTH_RESERVOIR, ECBlocks.AIR_RESERVOIR, ECBlocks.AIR_MILL_SYNTHESIZER});
        ECCapabilityHandler.deferBlockCapabilityBellow(event, ElementalCraftCapabilities.ElementStorage.BLOCK_FOR_ELEMENT, new Supplier[]{ECBlocks.FIRE_RESERVOIR, ECBlocks.WATER_RESERVOIR, ECBlocks.EARTH_RESERVOIR, ECBlocks.AIR_RESERVOIR, ECBlocks.AIR_MILL_SYNTHESIZER});
        ECCapabilityHandler.deferBlockCapabilityBellow(event, ElementContainer.CAPABILITY, new Supplier[]{ECBlocks.FIRE_RESERVOIR, ECBlocks.WATER_RESERVOIR, ECBlocks.EARTH_RESERVOIR, ECBlocks.AIR_RESERVOIR});
        ECCapabilityHandler.registerElementHolderCapabilities(event, ECItems.FIRE_HOLDER);
        ECCapabilityHandler.registerElementHolderCapabilities(event, ECItems.WATER_HOLDER);
        ECCapabilityHandler.registerElementHolderCapabilities(event, ECItems.EARTH_HOLDER);
        ECCapabilityHandler.registerElementHolderCapabilities(event, ECItems.AIR_HOLDER);
        ECCapabilityHandler.registerElementHolderCapabilities(event, ECItems.PURE_HOLDER);
        event.registerItem(ElementalCraftCapabilities.ElementStorage.ITEM, (stack, v) -> ((ReceptacleItem)stack.getItem()).getElementStorage((ItemStack)stack), new ItemLike[]{(ItemLike)ECBlocks.FIRE_SOURCE.get(), (ItemLike)ECBlocks.WATER_SOURCE.get(), (ItemLike)ECBlocks.EARTH_SOURCE.get(), (ItemLike)ECBlocks.AIR_SOURCE.get()});
        event.registerItem(ElementalCraftCapabilities.SourceTrait.ITEM, (stack, v) -> ReceptacleItem.getTraitHolder(stack), new ItemLike[]{(ItemLike)ECBlocks.FIRE_SOURCE.get(), (ItemLike)ECBlocks.WATER_SOURCE.get(), (ItemLike)ECBlocks.EARTH_SOURCE.get(), (ItemLike)ECBlocks.AIR_SOURCE.get()});
        ECCapabilityHandler.registerPlayerCapabilities(event);
    }

    @SafeVarargs
    private static <T, C> void deferBlockCapabilityBellow(RegisterCapabilitiesEvent event, BlockCapability<T, C> capability, Supplier<? extends Block> ... blocks) {
        event.registerBlock(capability, (l, p, s, be, c) -> {
            if (s.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
                return l.getCapability(capability, p.below(), null, null, c);
            }
            return null;
        }, (Block[])Arrays.stream(blocks).map(Supplier::get).toArray(Block[]::new));
    }

    private static void registerElementHolderCapabilities(RegisterCapabilitiesEvent event, Supplier<? extends AbstractElementHolderItem> holder) {
        AbstractElementHolderItem item = holder.get();
        event.registerItem(ElementalCraftCapabilities.ElementStorage.ITEM, (stack, v) -> item.getElementStorage((ItemStack)stack), new ItemLike[]{item});
    }

    private static void registerCraftingBlockEntityCapabilities(RegisterCapabilitiesEvent event, DeferredHolder<BlockEntityType<?>, ? extends BlockEntityType<? extends AbstractECCraftingBlockEntity<?, ?>>> holder) {
        BlockEntityType type = (BlockEntityType)holder.get();
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, type, IContainerBlockEntity::getItemHandler);
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, type, (blockEntity, v) -> blockEntity.getRuneHandler());
    }

    private static <T extends BlockEntity & IRuneableBlockEntity> void registerIERCapabilities(RegisterCapabilitiesEvent event, DeferredHolder<BlockEntityType<?>, ? extends BlockEntityType<T>> holder) {
        ECCapabilityHandler.registerIERCapabilities(event, (BlockEntityType)holder.get());
    }

    private static <T extends BlockEntity & IRuneableBlockEntity> void registerIERCapabilities(RegisterCapabilitiesEvent event, BlockEntityType<T> type) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, type, (rec$, x$0) -> ((IContainerBlockEntity)rec$).getItemHandler((Direction)x$0));
        ECCapabilityHandler.registerElementRunesCapabilities(event, type);
    }

    private static <T extends BlockEntity & IElementStorageBlocKEntity> void registerElementRunesCapabilities(RegisterCapabilitiesEvent event, DeferredHolder<BlockEntityType<?>, ? extends BlockEntityType<T>> holder) {
        ECCapabilityHandler.registerElementRunesCapabilities(event, (BlockEntityType)holder.get());
    }

    private static <T extends BlockEntity & IElementStorageBlocKEntity> void registerElementRunesCapabilities(RegisterCapabilitiesEvent event, BlockEntityType<T> type) {
        event.registerBlockEntity(ElementalCraftCapabilities.ElementStorage.BLOCK, type, (blockEntity, v) -> ((IElementStorageBlocKEntity)blockEntity).getElementStorage());
        event.registerBlockEntity(ElementalCraftCapabilities.RuneHandler.BLOCK, type, (blockEntity, v) -> ((IRuneableBlockEntity)blockEntity).getRuneHandler());
    }

    private static void registerSourceBreederPedestalCapabilities(RegisterCapabilitiesEvent event) {
        BlockEntityType type = (BlockEntityType)ECBlockEntityTypes.SOURCE_BREEDER_PEDESTAL.get();
        ECCapabilityHandler.registerIERCapabilities(event, type);
        event.registerBlockEntity(ElementalCraftCapabilities.SourceTrait.BLOCK, type, (pedestal, v) -> pedestal.getTraitHolder());
    }

    private static void registerPlayerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(ElementalCraftCapabilities.ElementStorage.ENTITY, EntityType.PLAYER, (player, v) -> new PlayerElementStorage((Player)player));
        event.registerEntity(ElementalCraftCapabilities.ElementStorage.ENTITY_FOR_ELEMENT, EntityType.PLAYER, (player, t) -> {
            if (t == null || t == ElementType.NONE) {
                return EmptyElementStorage.getSingle(ElementType.NONE);
            }
            IElementStorage s = (IElementStorage)player.getCapability(ElementalCraftCapabilities.ElementStorage.ENTITY, null);
            if (s == null) {
                return EmptyElementStorage.getSingle(t);
            }
            return s.forElement((ElementType)t);
        });
        event.registerEntity(ISpellTickManager.CAPABILITY, EntityType.PLAYER, (player, v) -> {
            ISpellTickManager iSpellTickManager;
            SpellTickManager spellTickManager = (SpellTickManager)player.getData(ECDataAttachments.SPELL_TICK_MANAGER);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                iSpellTickManager = new PlayerSpellTickManager(serverPlayer, spellTickManager);
            } else {
                iSpellTickManager = spellTickManager;
            }
            return iSpellTickManager;
        });
        event.registerEntity(IJewelHandler.CAPABILITY, EntityType.PLAYER, (player, v) -> {
            if (player.level().isClientSide) {
                return new ClientJewelHandler();
            }
            return (IJewelHandler)player.getData(ECDataAttachments.JEWEL_HANDLER);
        });
    }
}

